<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Api extends CI_Controller
{
	private $is_client_service = "frontend-client";
	private $is_auth_key = "Biddapit";
	private $is_content_type = "application/json";

	public function __construct()
	{
		parent::__construct();

		header('Access-Control-Allow-Origin: *');
		header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');
		header('Access-Control-Allow-Headers: Origin, Content-Type, X-Auth-Token');
		$this->load->model('Api_model');
	}

	private function common_response($message, $status)
	{
		echo json_encode(["data" => ['status' => $status, 'message' => $message]]);
		exit();
	}

	public function category($type)
	{
		$method = $_SERVER['REQUEST_METHOD'];
		if ($method !== 'GET') {
			return $this->common_response('Method not allowed', 405);
		}
		$client_service = $this->input->get_request_header('Client-Service', TRUE);
		$auth_key = $this->input->get_request_header('Auth-Key', TRUE);
		if ($client_service == $this->is_client_service && $auth_key == $this->is_auth_key) {
			$category = $this->Api_model->category_list($type);
			$success = array('status' => 200, 'message' => 'Success', 'category' => $category);
			echo json_encode($success);
			exit();
		} else {
			return $this->common_response('Unauthorized', 401);
		}
	}


	public function live_running_and_upcoming_model_test($type, $category_slug)
	{
		$method = $_SERVER['REQUEST_METHOD'];
		if ($method !== 'GET') {
			return $this->common_response('Method not allowed', 405);
		}
		$client_service = $this->input->get_request_header('Client-Service', TRUE);
		$auth_key = $this->input->get_request_header('Auth-Key', TRUE);
		if ($client_service == $this->is_client_service && $auth_key == $this->is_auth_key) {
			$decodedSlug = urldecode($category_slug);
			$today_date = date('Y-m-d');
			$all = $this->Api_model->get_model_tests_all($decodedSlug, $today_date, $type);
			$live = array_merge($all['live'], $all['running']);
			$upcoming = $all['upcoming'];
			$category = $all['category'];
			$success = array('status' => 200, 'message' => 'Success', 'modelTestLiveAndRunning' => $live, 'modelTestUpcoming' => $upcoming, "categoryInfo" => $category);
			echo json_encode($success);
			exit();
		} else {
			$this->common_response('Unauthorized', 401);
		}
	}

	public function archive_model_test()
	{
		$params = json_decode(file_get_contents('php://input'), true);
		$client_service = $params['ClientService'];
		$auth_key = $params['AuthKey'];
		$content_type = $params['ContentType'];
		$category_slug = $params['category_slug'];
		$start = $params['start'];
		$limit = $params['limit'];

		$decodedSlug = urldecode($category_slug);
		$method = $_SERVER['REQUEST_METHOD'];
		if ($method == 'POST') {
			if ($client_service == $this->is_client_service && $auth_key == $this->is_auth_key && $content_type == $this->is_content_type) {
				$today_date = date('Y-m-d');
				$model_test = $this->Api_model->select_archive_model_test($limit, $start, $decodedSlug, $today_date);
				$success = array('status' => 200, 'message' => 'Success', 'archiveModel' => $model_test);
				echo json_encode($success);
				exit();
			} else {
				$error = array("data" => ['status' => 401, 'message' => 'Unauthorized']);
				echo json_encode($error);
				exit();
			}
		} else {
			$error = array("data" => ['status' => 402, 'message' => 'Method not allowed']);
			echo json_encode($error);
			exit();
		}
	}

	public function previous_question_year()
	{
		$params = json_decode(file_get_contents('php://input'), true);
		$client_service = $params['ClientService'];
		$auth_key = $params['AuthKey'];
		$content_type = $params['ContentType'];
		$category_slug = $params['category_slug'];
		$start = $params['start'];
		$limit = $params['limit'];
		$decodedSlug = urldecode($category_slug);
		$method = $_SERVER['REQUEST_METHOD'];
		if ($method == 'POST') {
			if ($client_service == $this->is_client_service && $auth_key == $this->is_auth_key && $content_type == $this->is_content_type) {
				$model_test = $this->Api_model->select_previous_question_year($limit, $start, $decodedSlug);
				$success = array('status' => 200, 'message' => 'Success', 'previousModel' => $model_test);
				echo json_encode($success);
				exit();
			} else {
				$error = array("data" => ['status' => 402, 'message' => 'Unauthorized']);
				echo json_encode($error);
				exit();
			}
		} else {
			$error = array("data" => ['status' => 402, 'message' => 'Method not allowed']);
			echo json_encode($error);
			exit();
		}
	}

	public function exam_question_list_by_slug()
	{
		$params = json_decode(file_get_contents('php://input'), true);
		$client_service = $params['ClientService'];
		$auth_key = $params['AuthKey'];
		$content_type = $params['ContentType'];
		$model_test_slug = $params['model_test_slug'];
		$decodedSlug = urldecode($model_test_slug);
		$method = $_SERVER['REQUEST_METHOD'];
		if ($method == 'POST') {
			if ($client_service == $this->is_client_service && $auth_key == $this->is_auth_key && $content_type == $this->is_content_type) {
				$question_list = $this->Api_model->select_exam_question_list_by_slug($decodedSlug);
				$result = $this->Main_model->getValueRow("model_test_slug = '$decodedSlug'", 'biddapit_model_test', '*', "id desc");
				$sendData = array();
				foreach ($question_list as $v_list) {
					$data = array(
						'subject_id' => $v_list->subject_id,
						'subject_name' => $v_list->subject_name,
						'question_id' => $v_list->id,
						'question' => $v_list->question,
						'option_one' => $v_list->option_one,
						'option_two' => $v_list->option_two,
						'option_three' => $v_list->option_three,
						'option_four' => $v_list->option_four,
						'option_five' => $v_list->option_five,
						'option_six' => $v_list->option_six,
						'answer_description' => $v_list->answer_description,
						'status' => 0,
						'user_answer' => '',
						'answer' => $v_list->answer
					);
					$sendData[] = $data;
				}

				$minutes = $result->exam_duration;
				$hours = floor($minutes / 60);
				$remainingMinutes = $minutes % 60;
				$model_info = array(
					'hours' => $hours,
					'minutes' => $remainingMinutes,
					'right_marks' => $result->per_question_right_marks,
					'wrong_marks' => $result->per_question_wrong_marks,
					'total_question' => $result->total_question,
					'model_test_slug' => $result->model_test_slug,
					'model_test_id' => $result->id,
				);
				$success = array('status' => 200, 'message' => 'Success', 'question_list' => $sendData, 'modelInfo' => $model_info);
				echo json_encode($success);
				exit();
			} else {
				$this->common_response('Unauthorized', 402);
			}
		} else {
			$this->common_response('Method not allowed', 402);
		}
	}

	public function user_login()
	{
		$params = json_decode(file_get_contents('php://input'), true);
		$client_service = $params['ClientService'];
		$auth_key = $params['AuthKey'];
		$content_type = $params['ContentType'];
		$mobile_number = $params['mobile_number'];
		$enteredPassword = $params['password'];
		$method = $_SERVER['REQUEST_METHOD'];
		if ($method == 'POST') {
			if ($client_service == $this->is_client_service && $auth_key == $this->is_auth_key && $content_type == $this->is_content_type) {
				$check = $this->Api_model->check_login($mobile_number);
				if ($check) {
					if (password_verify($enteredPassword, $check->password)) {
						$data = $this->Api_model->getValueRow("user_name = '$mobile_number'", 'master_user', '*', "id desc");
						$success = array('status' => 200, 'message' => 'Success', 'data' => $data);
						echo json_encode($success);
						exit();
					} else {
						$this->common_response('Unauthorized', 402);
					}
				} else {
					$this->common_response('Unauthorized', 402);
				}
			} else {
				$this->common_response('Unauthorized', 402);
			}
		} else {
			$this->common_response('Method not allowed', 402);
		}
	}

	public function update_user_status()
	{
		$params = json_decode(file_get_contents('php://input'), true);
		$client_service = $params['ClientService'];
		$auth_key = $params['AuthKey'];
		$content_type = $params['ContentType'];
		$mobile_number = $params['mobile_number'];
		$method = $_SERVER['REQUEST_METHOD'];
		if ($method == 'POST') {
			if ($client_service == $this->is_client_service && $auth_key == $this->is_auth_key && $content_type == $this->is_content_type) {
				$data = array(
					'date' => date('Y-m-d'),
					'status' => 1
				);
				$this->Main_model->updateData($data, "master_user", "user_name='$mobile_number'");
				$success = array('status' => 200, 'message' => 'Success');
				echo json_encode($success);
				exit();
			} else {
				$this->common_response('Unauthorized', 402);
			}
		} else {
			$this->common_response('Method not allowed', 402);

		}
	}

	public function user_registration()
	{
		$params = json_decode(file_get_contents('php://input'), true);
		$client_service = $params['ClientService'];
		$auth_key = $params['AuthKey'];
		$content_type = $params['ContentType'];
		$full_name = $params['full_name'];
		$mobile_number = $params['mobile_number'];
		$password = $params['password'];
		$method = $_SERVER['REQUEST_METHOD'];
		if ($method == 'POST') {
			if ($client_service == $this->is_client_service && $auth_key == $this->is_auth_key && $content_type == $this->is_content_type) {
				$hashedPassword = password_hash($password, PASSWORD_DEFAULT);
				$check = $this->Api_model->check_login($mobile_number);
				if ($check) {
					$success = array('status' => 201, 'message' => 'Success');
					echo json_encode($success);
					exit();
				} else {
					$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));
					$data = array(
						'profile_name' => $full_name,
						'user_name' => $mobile_number,
						'password' => $hashedPassword,
						'status' => 0,
						'role_id' => 0,
						'date_and_time' => $dt->format('F j, Y, g:i a')
					);
					$this->Api_model->add_user($data, 'master_user');
					$success = array('status' => 200, 'message' => 'Success');
					echo json_encode($success);
					exit();
				}
			} else {
				$this->common_response('Unauthorized', 402);
			}
		} else {
			$this->common_response('Method not allowed', 402);

		}
	}

	public function otp_send()
	{
		$params = json_decode(file_get_contents('php://input'), true);
		$client_service = $params['ClientService'];
		$auth_key = $params['AuthKey'];
		$content_type = $params['ContentType'];
		$mobile_number = $params['mobile_number'];
		$method = $_SERVER['REQUEST_METHOD'];
		if ($method == 'POST') {
			if ($client_service == $this->is_client_service && $auth_key == $this->is_auth_key && $content_type == $this->is_content_type) {
				$checkUser = $this->Api_model->getValueRow("user_name = '$mobile_number'", 'master_user', '*', "id desc");
				if ($checkUser) {
					$todayDate = date('Y-m-d');
					$check_limit = $this->Api_model->getValue("mobile_number = '$mobile_number' and date='$todayDate'", 'master_common', '*', "id desc");
					if (count($check_limit) <= 2) {
						$otp = 12345;
						$hashedOTP = password_hash($otp, PASSWORD_DEFAULT);
						$data = array(
							'mobile_number' => $mobile_number,
							'otp' => $hashedOTP,
							'status' => 0,
							'date' => date('Y-m-d')
						);
						$this->Api_model->insertData($data, 'master_common');
						$success = array('status' => 200, 'message' => 'Success');
						echo json_encode($success);
						exit();
					} else {
						$success = array('status' => 202, 'message' => 'Success');
						echo json_encode($success);
						exit();
					}
				} else {
					$this->common_response('মোবাইল নম্বরটি সঠিক নয়, আপনার রেজিস্টার করা মোবাইল নম্বর দিন।', 402);
				}
			} else {
				$this->common_response('Unauthorized', 402);
			}
		} else {
			$this->common_response('Method not allowed', 402);
		}
	}

	public function otp_verify()
	{
		$params = json_decode(file_get_contents('php://input'), true);
		$client_service = $params['ClientService'];
		$auth_key = $params['AuthKey'];
		$content_type = $params['ContentType'];
		$mobile_number = $params['mobile_number'];
		$enteredOtp = $params['otp'];
		$method = $_SERVER['REQUEST_METHOD'];
		if ($method == 'POST') {
			if ($client_service == $this->is_client_service && $auth_key == $this->is_auth_key && $content_type == $this->is_content_type) {
				$checkOtp = $this->Api_model->select_otp($mobile_number);
				if ($checkOtp) {
					if (password_verify($enteredOtp, $checkOtp->otp)) {
						$this->common_response('Success', 200);
					} else {
						$this->common_response('আপনার OTP ভুল হয়েছে, দয়া করে আবার চেষ্টা করুন।', 201);
					}
				} else {
					$this->common_response('আপনার OTP ভুল হয়েছে, দয়া করে আবার চেষ্টা করুন।', 201);
				}
			} else {
				$this->common_response('Unauthorized', 401);
			}
		} else {
			$this->common_response('Method not allowed', 402);
		}
	}

	public function update_password()
	{
		$params = json_decode(file_get_contents('php://input'), true);
		$client_service = $params['ClientService'];
		$auth_key = $params['AuthKey'];
		$content_type = $params['ContentType'];
		$mobile_number = $params['mobile_number'];
		$password = $params['password'];
		$method = $_SERVER['REQUEST_METHOD'];
		if ($method == 'POST') {
			if ($client_service == $this->is_client_service && $auth_key == $this->is_auth_key && $content_type == $this->is_content_type) {
				$hashedPassword = password_hash($password, PASSWORD_DEFAULT);
				$data = array('password' => $hashedPassword);
				$this->Main_model->updateData($data, "master_user", "user_name='$mobile_number'");
				$data = $this->Api_model->getValueRow("user_name = '$mobile_number'", 'master_user', '*', "id desc");
				$success = array('status' => 200, 'message' => 'Success', 'data' => $data);
				echo json_encode($success);
				exit();
			} else {
				$this->common_response('Unauthorized', 401);
			}
		} else {
			$this->common_response('Method not allowed', 402);
		}
	}

	public function submit_answer()
	{
		$params = json_decode(file_get_contents('php://input'), true);
		$client_service = $params['ClientService'];
		$auth_key = $params['AuthKey'];
		$content_type = $params['ContentType'];
		$user_id = $params['user_id'];
		$answer_list = $params['answer_list'];
		$correct = $params['correct'];
		$wrong = $params['wrong'];
		$skipped = $params['skipped'];
		$total_marks = $params['total_marks'];
		$total_question = $params['total_question'];
		$model_test_id = $params['model_test_id'];
		$method = $_SERVER['REQUEST_METHOD'];
		if ($method == 'POST') {
			if ($client_service == $this->is_client_service && $auth_key == $this->is_auth_key && $content_type == $this->is_content_type) {
				for ($i = 0; $i < count($answer_list); $i++) {
					$question_answer = array(
						"model_test_id" => $model_test_id,
						"user_id" => $user_id,
						"subject_id" => $answer_list[$i]['subject_id'],
						"question_id" => $answer_list[$i]['question_id'],
						"user_answer" => $answer_list[$i]['user_answer'],
						"answer" => $answer_list[$i]['answer'],
						"status" => $answer_list[$i]['status']
					);
					$this->Main_model->insertData($question_answer, 'biddapit_question_answer');
				}
				$prevResult = $this->Main_model->getValueRow("user_id = '$user_id'", 'biddapit_question_answer_summary', '*', "id desc");

				if (($total_marks / $total_question) * 100 >= 40) {
					$isPassed = 1;
				} else {
					$isPassed = 0;
				}

				if ($prevResult) {
					$answer_summary = array(
						'user_id' => $user_id,
						'total_exam' => $prevResult->total_exam + 1,
						'total_success' => $isPassed + $prevResult->total_success,
						'total_marks' => $total_marks + $prevResult->total_marks,
						'total_question' => $total_question + $prevResult->total_question,
						'correct' => $correct + $prevResult->correct,
						'wrong' => $wrong + $prevResult->wrong,
						'skipped' => $skipped + $prevResult->skipped
					);
					$this->Main_model->updateData($answer_summary, "biddapit_question_answer_summary", "user_id='$user_id'");
				} else {
					$answer_summary = array(
						'user_id' => $user_id,
						'total_exam' => 1,
						'total_success' => $isPassed,
						'total_marks' => $total_marks,
						'total_question' => $total_question,
						'correct' => $correct,
						'wrong' => $wrong,
						'skipped' => $skipped
					);
					$this->Main_model->insertData($answer_summary, 'biddapit_question_answer_summary');
				}

				$merit_list = array(
					'user_id' => $user_id,
					'model_test_id' => $model_test_id,
					'total_marks' => $total_marks
				);
				$this->Main_model->insertData($merit_list, 'biddapit_merit_list');
				$success = array('status' => 200, 'message' => 'Success');
				echo json_encode($success);
				exit();
			} else {
				$this->common_response('Unauthorized', 401);
			}
		} else {
			$this->common_response('Method not allowed', 402);
		}
	}

	public function user_exam_summary()
	{
		$params = json_decode(file_get_contents('php://input'), true);
		$client_service = $params['ClientService'];
		$auth_key = $params['AuthKey'];
		$content_type = $params['ContentType'];
		$user_id = $params['user_id'];
		$method = $_SERVER['REQUEST_METHOD'];
		if ($method == 'POST') {
			if ($client_service == $this->is_client_service && $auth_key == $this->is_auth_key && $content_type == $this->is_content_type) {
				$result = $this->Main_model->getValueRow("user_id = '$user_id'", 'biddapit_question_answer_summary', '*', "id desc");
				$success = array('status' => 200, 'message' => 'Success', 'summary' => $result);
				echo json_encode($success);
				exit();
			} else {
				$this->common_response('Unauthorized', 401);
			}
		} else {
			$this->common_response('Method not allowed', 402);
		}
	}

	public function user_profile_data()
	{
		$params = json_decode(file_get_contents('php://input'), true);
		$client_service = $params['ClientService'];
		$auth_key = $params['AuthKey'];
		$content_type = $params['ContentType'];
		$user_id = $params['user_id'];
		$method = $_SERVER['REQUEST_METHOD'];
		if ($method == 'POST') {
			if ($client_service == $this->is_client_service && $auth_key == $this->is_auth_key && $content_type == $this->is_content_type) {
				$result = $this->Main_model->getValueRow("id = '$user_id'", 'master_user', '*', "id desc");
				$success = array('status' => 200, 'message' => 'Success', 'data' => $result);
				echo json_encode($success);
				exit();
			} else {
				$this->common_response('Unauthorized', 401);
			}
		} else {
			$this->common_response('Method not allowed', 402);
		}
	}

	public function update_profile()
	{
		$params = json_decode(file_get_contents('php://input'), true);
		$client_service = $params['ClientService'];
		$auth_key = $params['AuthKey'];
		$content_type = $params['ContentType'];
		$user_id = $params['user_id'];
		$profile_name = $params['profile_name'];
		$date_of_birth = $params['date_of_birth'];
		$address = $params['address'];
		$gender = $params['gender'];
		$email = $params['email'];
		$method = $_SERVER['REQUEST_METHOD'];
		if ($method == 'POST') {
			if ($client_service == $this->is_client_service && $auth_key == $this->is_auth_key && $content_type == $this->is_content_type) {
				$result = $this->Main_model->getValueRow("id = '$user_id'", 'master_user', '*', "id desc");
				$data = array(
					'profile_name' => $profile_name,
					'date_of_birth' => $date_of_birth,
					'address' => $address,
					'gender' => $gender,
					'email' => $email,
				);
				$this->Main_model->updateData($data, "master_user", "id='$user_id'");
				$success = array('status' => 200, 'message' => 'Success');
				echo json_encode($success);
				exit();
			} else {
				$this->common_response('Unauthorized', 401);
			}
		} else {
			$this->common_response('Method not allowed', 402);
		}
	}

	public function user_password_change()
	{
		$params = json_decode(file_get_contents('php://input'), true);
		$client_service = $params['ClientService'];
		$auth_key = $params['AuthKey'];
		$content_type = $params['ContentType'];
		$mobile_number = $params['mobile_number'];
		$password = $params['password'];
		$current_password = $params['current_password'];
		$method = $_SERVER['REQUEST_METHOD'];
		if ($method == 'POST') {
			if ($client_service == $this->is_client_service && $auth_key == $this->is_auth_key && $content_type == $this->is_content_type) {
				$check = $this->Api_model->check_login($mobile_number);
				if ($check) {
					if (password_verify($current_password, $check->password)) {
						$data = array(
							'password' => password_hash($password, PASSWORD_DEFAULT)
						);
						$this->Main_model->updateData($data, "master_user", "user_name='$mobile_number'");
						$success = array('status' => 200, 'message' => 'Success');
						echo json_encode($success);
						exit();
					} else {
						$this->common_response('Incorrect current password', 405);
					}
				} else {
					$this->common_response('Unauthorized', 402);
				}
			} else {
				$this->common_response('Unauthorized', 401);
			}
		} else {
			$this->common_response('Method not allowed', 402);
		}
	}

	public function user_question_answer()
	{
		$params = json_decode(file_get_contents('php://input'), true);
		$client_service = $params['ClientService'];
		$auth_key = $params['AuthKey'];
		$content_type = $params['ContentType'];
		$user_id = $params['user_id'];
		$status = $params['status'];
		$method = $_SERVER['REQUEST_METHOD'];
		if ($method == 'POST') {
			if ($client_service == $this->is_client_service && $auth_key == $this->is_auth_key && $content_type == $this->is_content_type) {
				$subject = $this->Api_model->select_question_by_subject_name($user_id);
				$sendData = array();
				foreach ($subject as $v_subject) {
					$question = $this->Api_model->select_total_question($user_id, $v_subject->id, $status);
					$data = array(
						'subject_name' => $v_subject->subject_name,
						'subject_total_question' => $v_subject->total_question,
						'total_question' => $question->total,
					);
					$sendData[] = $data;
				}
				$success = array('status' => 200, 'message' => 'Success', 'data' => $sendData);
				echo json_encode($success);
				exit();
			} else {
				$this->common_response('Unauthorized', 401);
			}
		} else {
			$this->common_response('Method not allowed', 402);
		}
	}


	public function subject_list($status)
	{
		$method = $_SERVER['REQUEST_METHOD'];
		if ($method !== 'GET') {
			return $this->common_response('Method not allowed', 405);
		}
		$client_service = $this->input->get_request_header('Client-Service', TRUE);
		$auth_key = $this->input->get_request_header('Auth-Key', TRUE);
		if ($client_service == $this->is_client_service && $auth_key == $this->is_auth_key) {
			$subject = $this->Api_model->select_subject_by_status($status);
			$sendData = array();
			foreach ($subject as $v_subject) {
				$check = $this->Api_model->check_subject_child($v_subject->id, $status);
				if ($check) {
					$set_status = 1;
				} else {
					$set_status = 0;
				}
				$data = array(
					'subject_id' => $v_subject->id,
					'subject_name' => $v_subject->subject_name,
					'subject_slug' => $v_subject->subject_slug,
					'subject_image' => base_url() . "public/subject_images/" . $v_subject->subject_image,
					'status' => $set_status
				);
				$sendData[] = $data;
			}
			$success = array('status' => 200, 'message' => 'Success', 'data' => $sendData);
			echo json_encode($success);
			exit();
		} else {
			return $this->common_response('Unauthorized', 401);
		}
	}


	public function subject_child_list()
	{
		$params = json_decode(file_get_contents('php://input'), true);
		$client_service = $params['ClientService'];
		$auth_key = $params['AuthKey'];
		$content_type = $params['ContentType'];
		$status = $params['status'];
		$subject_slug = $params['subject_slug'];
		$method = $_SERVER['REQUEST_METHOD'];
		if ($method == 'POST') {
			if ($client_service == $this->is_client_service && $auth_key == $this->is_auth_key && $content_type == $this->is_content_type) {
				$subject_child = $this->Api_model->select_subject_child_by_status($status, $subject_slug);
				$sendData = array();
				foreach ($subject_child as $v_subject_child) {
					$check = $this->Api_model->check_subject_sub_child($v_subject_child->id, $status);
					if ($check) {
						$set_status = 1;
					} else {
						$set_status = 0;
					}
					$data = array(
						'subject_child_id' => $v_subject_child->id,
						'subject_child_name' => $v_subject_child->subject_child_name,
						'subject_child_slug' => $v_subject_child->subject_child_slug,
						'subject_child_image' => base_url() . "public/subject_images/" . $v_subject_child->child_image,
						'status' => $set_status
					);
					$sendData[] = $data;
				}
				$success = array('status' => 200, 'message' => 'Success', 'data' => $sendData);
				echo json_encode($success);
				exit();
			} else {
				$this->common_response('Unauthorized', 401);
			}
		} else {
			$this->common_response('Method not allowed', 402);
		}
	}

	public function subject_sub_child_list()
	{
		$params = json_decode(file_get_contents('php://input'), true);
		$client_service = $params['ClientService'];
		$auth_key = $params['AuthKey'];
		$content_type = $params['ContentType'];
		$status = $params['status'];
		$subject_child_slug = $params['subject_child_slug'];
		$method = $_SERVER['REQUEST_METHOD'];
		if ($method == 'POST') {
			if ($client_service == $this->is_client_service && $auth_key == $this->is_auth_key && $content_type == $this->is_content_type) {
				$subject_sub_child = $this->Api_model->select_subject_sub_child_by_status($status, $subject_child_slug);
				$sendData = array();
				foreach ($subject_sub_child as $v_sub_subject_child) {
					$data = array(
						'subject_child_id' => $v_sub_subject_child->id,
						'subject_sub_child_name' => $v_sub_subject_child->subject_sub_child_name,
						'subject_sub_child_slug' => $v_sub_subject_child->subject_sub_child_slug,
						'subject_sub_child_image' => base_url() . "public/subject_images/" . $v_sub_subject_child->sub_child_image,
					);
					$sendData[] = $data;
				}
				$success = array('status' => 200, 'message' => 'Success', 'data' => $sendData);
				echo json_encode($success);
				exit();
			} else {
				$this->common_response('Unauthorized', 401);
			}
		} else {
			$this->common_response('Method not allowed', 402);
		}
	}

	public function question_list()
	{
		$params = json_decode(file_get_contents('php://input'), true);
		$client_service = $params['ClientService'];
		$auth_key = $params['AuthKey'];
		$content_type = $params['ContentType'];
		$slug = $params['slug'];
		$page = $params['page'];
		$limit = $params['limit'];
		$user_id = $params['user_id'];
		$filter = $params['filterData'];
		$type = $params['type'];
		$method = $_SERVER['REQUEST_METHOD'];
		if ($method == 'POST') {
			if ($client_service == $this->is_client_service && $auth_key == $this->is_auth_key && $content_type == $this->is_content_type) {
				$table_field = "subject_child_and_sub_child_merge_slug";
				$getId = $this->Api_model->select_all_id($slug, $table_field);
				if ($getId) {
					$subject_id = $getId->subject_id;
					$subject_child_id = $getId->subject_child_id;
					$subject_sub_child_id = $getId->id;
					$result1 = $this->Api_model->select_question_list($limit, $page, $type, $filter, $user_id, $subject_id, $subject_child_id, $subject_sub_child_id);
					$total = (int)($result1['total']);
					$question_list = $result1['rows'];
				} else {
					$table_field1 = "subject_and_child_merge_slug";
					$getId1 = $this->Api_model->select_all_id($slug, $table_field1);
					if ($getId1) {
						$subject_id1 = $getId1->subject_id;
						$subject_child_id1 = $getId1->subject_child_id;
						$result2 = $this->Api_model->select_question_list($limit, $page, $type, $filter, $user_id, $subject_id1, $subject_child_id1);
						$total = (int)($result2['total']);
						$question_list = $result2['rows'];
					} else {
						$table_field2 = "subject_slug";
						$getId2 = $this->Api_model->select_all_id($slug, $table_field2);
						if ($getId2) {
							$subject_id2 = $getId2->subject_id;
							$result3 = $this->Api_model->select_question_list($limit, $page, $type, $filter, $user_id, $subject_id2);
							$total = (int)($result3['total']);
							$question_list = $result3['rows'];
						} else {
							$question_list = array();
							$total = 0;
						}
					}
				}

				$sendData = [];
				foreach ($question_list as $v_question) {
					$optionArray = array_filter([
						$v_question->option_one,
						$v_question->option_two,
						$v_question->option_three,
						$v_question->option_four,
						$v_question->option_five,
						$v_question->option_six,
					]);
					$questions = [
						'marked_question_active' => $v_question->marked_question,
						'favorite_question_active' => $v_question->favorite_question,
						'marked_question' => $v_question->marked_question,
						'favorite_question' => $v_question->favorite_question,
						'answer' => $v_question->answer,
						'solution' => $v_question->answer_description,
						'question_id' => $v_question->id,
						'question' => $v_question->question,
						'question_slug' => $v_question->question_slug,
						'options' => array_values($optionArray),
						'description' => $v_question->description != "" ? explode(",", $v_question->description) : ""
					];
					$sendData[] = $questions;
				}
				$data = [
					'total' => $total,
					'questions' => $sendData,
				];
				$success = ['status' => 200, 'message' => 'Success', 'data' => $data];
				echo json_encode($success);
				exit();
			} else {
				$this->common_response('Unauthorized', 401);
			}
		} else {
			$this->common_response('Method not allowed', 402);
		}
	}

	public function add_reading_question()
	{
		$params = json_decode(file_get_contents('php://input'), true);
		$client_service = $params['ClientService'];
		$auth_key = $params['AuthKey'];
		$content_type = $params['ContentType'];
		$view_answer = $params['view_answer_id'];
		$remove_answer_id = $params['remove_answer_id'];
		$favorite_question = $params['favorite_question_id'];
		$remove_favorite_question_id = $params['remove_favorite_question_id'];
		$user_id = $params['user_id'];
		$method = $_SERVER['REQUEST_METHOD'];
		if ($method == 'POST') {
			if ($client_service == $this->is_client_service && $auth_key == $this->is_auth_key && $content_type == $this->is_content_type) {
				if (count($remove_answer_id) > 0) {
					foreach ($remove_answer_id as $question_id1) {
						$this->Api_model->deleteData("user_id = '$user_id' and question_id='$question_id1'", "biddapit_reading_question");
					}
				}
				if (count($view_answer) > 0) {
					foreach ($view_answer as $question_id2) {
						$check = $this->Api_model->check_entry($user_id, $question_id2, 1);
						if ($check) {
						} else {
							$data2 = array(
								'user_id' => $user_id,
								'question_id' => $question_id2,
								'type' => 1
							);
							$this->Api_model->insertData($data2, 'biddapit_reading_question');
						}
					}
				}
				if (count($remove_favorite_question_id) > 0) {
					foreach ($remove_favorite_question_id as $question_id3) {
						$this->Api_model->deleteData("user_id = '$user_id' and question_id='$question_id3'", "biddapit_reading_question");
					}
				}
				if (count($favorite_question) > 0) {
					foreach ($favorite_question as $question_id4) {
						$check = $this->Api_model->check_entry($user_id, $question_id4, 2);
						if ($check) {
						} else {
							$data4 = array(
								'user_id' => $user_id,
								'question_id' => $question_id4,
								'type' => 2
							);
							$this->Api_model->insertData($data4, 'biddapit_reading_question');
						}
					}
				}
				$success = ['status' => 200, 'message' => 'Success'];
				echo json_encode($success);
				exit();
			} else {
				$this->common_response('Unauthorized', 401);
			}
		} else {
			$this->common_response('Method not allowed', 402);
		}
	}

	public function question_details()
	{
		$params = json_decode(file_get_contents('php://input'), true);
		$client_service = $params['ClientService'];
		$auth_key = $params['AuthKey'];
		$content_type = $params['ContentType'];
		$question_slug = $params['question_slug'];
		$method = $_SERVER['REQUEST_METHOD'];
		if ($method == 'POST') {
			if ($client_service == $this->is_client_service && $auth_key == $this->is_auth_key && $content_type == $this->is_content_type) {
				$question = $this->Api_model->getValueRow("question_slug = '$question_slug'", 'biddapit_question', '*', "id desc");
				$success = ['status' => 200, 'message' => 'Success', 'data' => $question];
				echo json_encode($success);
				exit();
			} else {
				$this->common_response('Unauthorized', 401);
			}
		} else {
			$this->common_response('Method not allowed', 402);
		}
	}

	public function question_edit()
	{
		$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));
		$params = json_decode(file_get_contents('php://input'), true);
		$client_service = $params['ClientService'];
		$auth_key = $params['AuthKey'];
		$content_type = $params['ContentType'];
		$method = $_SERVER['REQUEST_METHOD'];
		if ($method == 'POST') {
			if ($client_service == $this->is_client_service && $auth_key == $this->is_auth_key && $content_type == $this->is_content_type) {
				$result = array(
					'user_id' => $params['user_id'],
					'question' => $params['question'],
					'question_id' => $params['question_id'],
					'option_one' => $params['option_one'],
					'option_two' => $params['option_two'],
					'option_three' => $params['option_three'],
					'option_four' => $params['option_four'],
					'solve_note_edit' => $params['solve_note_edit'],
					'option_spelling' => $params['option_spelling'],
					'wrong_answer_edit' => $params['wrong_answer_edit'],
					'solve_note' => $params['solve_note'],
					'question_spelling' => $params['question_spelling'],
					'date_and_time' => $dt->format('F j, Y, g:i a'),
				);
				$this->Api_model->insertData($result, 'biddapit_question_report');
				$success = ['status' => 200, 'message' => 'Success'];
				echo json_encode($success);
				exit();
			} else {
				$this->common_response('Unauthorized', 401);
			}
		} else {
			$this->common_response('Method not allowed', 402);
		}
	}

	public function question_analytic()
	{
		$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));
		$params = json_decode(file_get_contents('php://input'), true);
		$client_service = $params['ClientService'];
		$auth_key = $params['AuthKey'];
		$content_type = $params['ContentType'];
		$user_id = $params['user_id'];
		$question_id = $params['question_id'];
		$method = $_SERVER['REQUEST_METHOD'];
		if ($method == 'POST') {
			if ($client_service == $this->is_client_service && $auth_key == $this->is_auth_key && $content_type == $this->is_content_type) {
				$result = $this->Api_model->count_answer($user_id, $question_id);
				$model_test = $this->Api_model->count_model_test($question_id);
				$data = array(
					'your_answer' => $result->user_status,
					'total_correct' => $result->total_correct,
					'total_wrong' => $result->total_wrong,
					'total_skip' => $result->total_skip,
					'model_test' => $model_test,
				);
				$success = ['status' => 200, 'message' => 'Success', 'data' => $data];
				echo json_encode($success);
				exit();
			} else {
				$this->common_response('Unauthorized', 401);
			}
		} else {
			$this->common_response('Method not allowed', 402);
		}
	}

	public function job_details()
	{
		$params = json_decode(file_get_contents('php://input'), true);
		$client_service = $params['ClientService'];
		$auth_key = $params['AuthKey'];
		$content_type = $params['ContentType'];
		$job_slug = $params['job_slug'];
		$method = $_SERVER['REQUEST_METHOD'];
		if ($method == 'POST') {
			if ($client_service == $this->is_client_service && $auth_key == $this->is_auth_key && $content_type == $this->is_content_type) {
				$jobList = $this->Api_model->select_job_details($job_slug);
				$category = $this->Api_model->select_job_by_category($jobList->category_id);
				$company_information = $this->Api_model->select_organization($jobList->organization_id);
				$recent_jobs = $this->Api_model->select_organization_recent_jobs($jobList->organization_id);
				$popular_jobs = $this->Api_model->select_popular_jobs();
				$data = array(
					'job_list' => $jobList,
					'category_wise_jobs' => $category,
					'company_information' => $company_information,
					'recent_jobs' => $recent_jobs,
					'popular_jobs' => $popular_jobs,
				);
				$success = ['status' => 200, 'message' => 'Success', 'data' => $data];
				echo json_encode($success);
				exit();
			} else {
				$this->common_response('Unauthorized', 401);
			}
		} else {
			$this->common_response('Method not allowed', 402);
		}
	}

	public function job_category()
	{
		$method = $_SERVER['REQUEST_METHOD'];
		if ($method !== 'GET') {
			return $this->common_response('Method not allowed', 405);
		}
		$client_service = $this->input->get_request_header('Client-Service', TRUE);
		$auth_key = $this->input->get_request_header('Auth-Key', TRUE);

		if ($client_service == $this->is_client_service && $auth_key == $this->is_auth_key) {
			$categoryList = $this->Api_model->categories_with_jobs();
			$success = ['status' => 200, 'message' => 'Success', 'data' => $categoryList];
			echo json_encode($success);
			exit();
		} else {
			$this->common_response('Unauthorized', 401);
		}
	}

	public function jobs_list()
	{
		$method = $_SERVER['REQUEST_METHOD'];
		if ($method !== 'GET') {
			return $this->common_response('Method not allowed', 405);
		}
		$client_service = $this->input->get_request_header('Client-Service', TRUE);
		$auth_key = $this->input->get_request_header('Auth-Key', TRUE);

		if ($client_service == $this->is_client_service && $auth_key == $this->is_auth_key) {
			$categoryList = $this->Api_model->last_twelve_jobs();
			$success = ['status' => 200, 'message' => 'Success', 'data' => $categoryList];
			echo json_encode($success);
			exit();
		} else {
			return $this->common_response('Unauthorized', 401);
		}
	}

	public function job_list()
	{
		$method = $_SERVER['REQUEST_METHOD'];
		if ($method !== 'GET') {
			return $this->common_response('Method not allowed', 405);
		}
		$client_service = $this->input->get_request_header('Client-Service', TRUE);
		$auth_key = $this->input->get_request_header('Auth-Key', TRUE);
		if ($client_service == $this->is_client_service && $auth_key == $this->is_auth_key) {
			$jobList = $this->Api_model->select_last_five_job();
			$success = ['status' => 200, 'message' => 'Success', 'data' => $jobList];
			echo json_encode($success);
			exit();
		} else {
			$this->common_response('Unauthorized', 401);
		}
	}

	public function check_exam()
	{
		$params = json_decode(file_get_contents('php://input'), true);
		$client_service = $params['ClientService'];
		$auth_key = $params['AuthKey'];
		$content_type = $params['ContentType'];
		$model_test_id = $params['model_test_id'];
		$user_id = $params['user_id'];
		$method = $_SERVER['REQUEST_METHOD'];
		if ($method == 'POST') {
			if ($client_service == $this->is_client_service && $auth_key == $this->is_auth_key && $content_type == $this->is_content_type) {
				$check = $this->Api_model->check_exam_taken($user_id, $model_test_id);
				if ($check) {
					$success = ['status' => 201, 'message' => 'Success'];
					echo json_encode($success);
					exit();
				} else {
					$success = ['status' => 200, 'message' => 'Success'];
					echo json_encode($success);
					exit();
				}
			} else {
				$this->common_response('Unauthorized', 401);
			}
		} else {
			$this->common_response('Method not allowed', 402);
		}
	}
}
