<?php

class Api_model extends CI_Model
{
	public function __construct()
	{
		parent::__construct();
	}

	public function getValue($cond = FALSE, $tableName = '', $select_qry = '*', $order = 'ID DESC')
	{
		$prefix = $this->config->item('DX_table_prefix');
		$tableName = $prefix . $tableName;
		$this->db->select($select_qry, FALSE);
		if ($cond): $this->db->where($cond);
		endif;
		$this->db->order_by($order);
		return $this->db->get($tableName)->result();
	}

	public function getValueRow($cond = FALSE, $tableName = '', $select_qry = '*', $order = 'ID DESC')
	{
		$prefix = $this->config->item('DX_table_prefix');
		$tableName = $prefix . $tableName;
		$this->db->select($select_qry, FALSE);
		if ($cond): $this->db->where($cond);
		endif;
		$this->db->order_by($order);
		return $this->db->get($tableName)->row();

	}

	function insertData($data = '', $tableName = '')
	{
		$prefix = $this->config->item('DX_table_prefix');
		$tableName = $prefix . $tableName;
		return $this->db->insert($tableName, $data);
	}

	function insertDataWithLastId($data = '', $tableName = '')
	{
		$prefix = $this->config->item('DX_table_prefix');
		$tableName = $prefix . $tableName;
		$this->db->insert($tableName, $data);
		$insert_id = $this->db->insert_id();
		return $insert_id;
	}

	function deleteData($cond = FALSE, $tableName = '')
	{
		if (!empty($cond)): $this->db->where($cond);
		endif;
		return $this->db->delete($tableName);
	}

	function updateData($data = '', $tableName1 = '', $cond = '')
	{
		$prefix = $this->config->item('DX_table_prefix');
		$tableName = $prefix . $tableName1;
		$this->db->where($cond);
		return $this->db->update($tableName, $data);
	}

	public function category_list($type, $slug = null)
	{
		$this->db->select('*');
		$this->db->where($type, 1);
		if ($slug) {
			$this->db->where("category_slug", $slug);
		}
		$query_result = $this->db->get('biddapit_category');
		$result = $query_result->result();
		return $result;
	}

	public function check_subject_child($subject_id, $status)
	{
		$this->db->select('id');
		$this->db->where('subject_id', $subject_id);
		$this->db->where($status, 1);
		$query_result = $this->db->get('biddapit_subject_child');
		$result = $query_result->row();
		return $result;
	}

	public function select_live_model_test($category_slug, $today_date)
	{
		$this->db->select('*')
			->from('biddapit_model_test')
			->where('exam_date', $today_date)
			->where('model_test_type', 2)
			->where('status', 1)
			->where('category_slug', $category_slug)
			->order_by('id', 'desc');
		return $this->db->get()->result();
	}

	public function select_running_model_test($category_slug, $today_date)
	{
		$this->db->select('*')
			->from('biddapit_model_test')
			->where('exam_date', $today_date)
			->where('model_test_type', 1)
			->where('status', 1)
			->where('category_slug', $category_slug)
			->order_by('id', 'desc');
		return $this->db->get()->result();
	}

	public function select_upcoming_model_test($category_slug, $today_date)
	{
		$this->db->select('*');
		$this->db->where('exam_date >', $today_date);
		$this->db->where('model_test_type', 1);
		$this->db->where('status', 1);
		$this->db->where('category_slug', $category_slug);
		$this->db->order_by('id', "desc");
		$query_result = $this->db->get('biddapit_model_test');
		$result = $query_result->result();
		return $result;
	}

	public function select_previous_year_model_test($category_slug)
	{
		$this->db->select('*');
		$this->db->where('model_test_type', 3);
		$this->db->where('status', 1);
		$this->db->where('category_slug', $category_slug);
		$this->db->order_by('id', "desc");
		$query_result = $this->db->get('biddapit_model_test');
		$result = $query_result->result();
		return $result;
	}

	public function get_model_tests_all($category_slug, $today_date, $type)
	{
		return [
			'live' => $this->select_live_model_test($category_slug, $today_date),
			'running' => $this->select_running_model_test($category_slug, $today_date),
			'upcoming' => $this->select_upcoming_model_test($category_slug, $today_date),
			'category' => $this->category_list($type, $category_slug),
		];
	}


	public function select_archive_model_test($limit, $start, $category_slug, $today_date)
	{
		$this->db->limit($limit, $start);
		$this->db->select('*');
		$this->db->where('exam_date <', $today_date);
		$this->db->where('model_test_type', 1);
		$this->db->where('status', 1);
		$this->db->where('category_slug', $category_slug);
		$this->db->order_by('id', "desc");
		$query_result = $this->db->get('biddapit_model_test');
		$result = $query_result->result();
		return $result;
	}

	public function select_previous_question_year($limit, $start, $category_slug)
	{
		$this->db->limit($limit, $start);
		$this->db->select('*');
		$this->db->where('model_test_type', 3);
		$this->db->where('status', 1);
		$this->db->where('category_slug', $category_slug);
		$this->db->order_by('id', "desc");
		$query_result = $this->db->get('biddapit_model_test');
		$result = $query_result->result();
		return $result;
	}

	public function select_exam_question_list_by_slug($slug)
	{
		$this->db->select('biddapit_question.answer_description,biddapit_subject.subject_name,biddapit_question.subject_id,biddapit_question.id,biddapit_question.question,biddapit_question.option_one,biddapit_question.option_two,biddapit_question.option_three,biddapit_question.option_four,biddapit_question.option_five,biddapit_question.option_six,biddapit_question.answer');
		$this->db->where('biddapit_model_test.model_test_slug', $slug);
		$this->db->join('biddapit_model_test_child', 'biddapit_model_test_child.model_test_id = biddapit_model_test.id');
		$this->db->join('biddapit_question', 'biddapit_question.id = biddapit_model_test_child.question_id');
		$this->db->join('biddapit_subject', 'biddapit_question.subject_id = biddapit_subject.id');
		$query_result = $this->db->get('biddapit_model_test');
		$result = $query_result->result();
		return $result;
	}

	public function select_model_test_details($slug)
	{
		$this->db->select('*');
		$this->db->where('model_test_slug', $slug);
		$query_result = $this->db->get('biddapit_model_test');
		$result = $query_result->row();
		return $result;
	}

	public function check_login($user_name)
	{
		$this->db->select('*');
		$this->db->where('user_name', $user_name);
		$query_result = $this->db->get('master_user');
		$result = $query_result->row();
		return $result;
	}

	function add_user($post_data)
	{
		$this->db->insert('master_user', $post_data);
		$insert_id = $this->db->insert_id();
		return $insert_id;
	}

	public function select_otp($mobile_number)
	{
		$this->db->select('otp');
		$this->db->where('mobile_number', $mobile_number);
		$this->db->order_by('id', 'desc');
		$query_result = $this->db->get('master_common');
		$result = $query_result->row();
		return $result;
	}

	public function select_question_by_subject_name($user_id)
	{
		$this->db->select('biddapit_subject.id,biddapit_subject.subject_name, count(question_id) total_question');
		$this->db->where('biddapit_question_answer.user_id', $user_id);
		$this->db->join('biddapit_subject', 'biddapit_subject.id = biddapit_question_answer.subject_id');
		$this->db->group_by('biddapit_subject.id,biddapit_subject.subject_name');
		$query_result = $this->db->get('biddapit_question_answer');
		$result = $query_result->result();
		return $result;
	}

	public function select_total_question($user_id, $subject_id, $status)
	{
		$this->db->select('count(id) total');
		$this->db->where('user_id', $user_id);
		$this->db->where('subject_id', $subject_id);
		$this->db->where('status', $status);
		$query_result = $this->db->get('biddapit_question_answer');
		$result = $query_result->row();
		return $result;
	}

	public function select_subject_by_status($status)
	{
		$this->db->select('id,subject_name,subject_slug,subject_image');
		$this->db->where($status, 1);
		$query_result = $this->db->get('biddapit_subject');
		$result = $query_result->result();
		return $result;
	}

	public function select_subject_child_by_status($status, $subject_slug)
	{
		$this->db->select('id,subject_child_name,subject_child_slug,child_image');
		$this->db->where($status, 1);
		$this->db->where('subject_slug', $subject_slug);
		$query_result = $this->db->get('biddapit_subject_child');
		$result = $query_result->result();
		return $result;
	}

	public function check_subject_sub_child($subject_child_id, $status)
	{
		$this->db->select('id');
		$this->db->where('subject_child_id', $subject_child_id);
		$this->db->where($status, 1);
		$query_result = $this->db->get('biddapit_subject_sub_child');
		$result = $query_result->row();
		return $result;
	}

	public function select_subject_sub_child_by_status($status, $slug)
	{
		$this->db->select('id,subject_sub_child_name,subject_sub_child_slug,sub_child_image');
		$this->db->where($status, 1);
		$this->db->where('subject_and_child_merge_slug', $slug);
		$query_result = $this->db->get('biddapit_subject_sub_child');
		$result = $query_result->result();
		return $result;
	}

	public function select_question_list($limit, $page, $type, $filter, $user_id, $subject_id, $subject_child_id = null, $subject_sub_child_id = null)
	{
		$limit = (int)$limit;
		$offset = max(0, (int)$page - 1);
		$this->db->start_cache();
		$this->db->from('biddapit_question');
		$this->db->join('biddapit_reading_question', "biddapit_reading_question.question_id = biddapit_question.id AND biddapit_reading_question.user_id = " . (int)$user_id, 'left');
		$this->db->join('biddapit_prev_year_question', 'biddapit_prev_year_question.question_id = biddapit_question.id', 'left');
		$this->db->join('biddapit_master_previous_year_exam', 'biddapit_master_previous_year_exam.id = biddapit_prev_year_question.previous_id', 'left');
		$this->db->where('biddapit_question.subject_id', (int)$subject_id);
		if ($subject_child_id) $this->db->where('biddapit_question.subject_child_id', (int)$subject_child_id);
		if ($subject_sub_child_id) $this->db->where('biddapit_question.subject_sub_child_id', (int)$subject_sub_child_id);
		if ((int)$type > 0) {
			if ((int)$type === 1) {
				$this->db->where('biddapit_question.question_type', (int)$filter);
			} else {
				$term = $this->db->escape_like_str((string)$filter);
				$this->db->group_start()->like('biddapit_question.question', $term, 'both', false)->group_end();
			}
		}
		$this->db->stop_cache();
		$this->db->select('COUNT(DISTINCT biddapit_question.id) AS total', false);
		$total_row = $this->db->get()->row();
		$total = (int)($total_row->total ?? 0);
		$this->db->select("biddapit_question.*,
        GROUP_CONCAT(DISTINCT biddapit_master_previous_year_exam.description SEPARATOR ', ') AS description,
        COALESCE(MAX(CASE WHEN biddapit_reading_question.type = 1 THEN 1 ELSE 0 END), 0) AS marked_question,
        COALESCE(MAX(CASE WHEN biddapit_reading_question.type = 2 THEN 1 ELSE 0 END), 0) AS favorite_question", false);
		$this->db->group_by('biddapit_question.id');
		$this->db->order_by('biddapit_question.id', 'DESC');
		$this->db->limit($limit, $offset);
		$rows = $this->db->get()->result();
		$this->db->flush_cache();
		return [
			'total' => $total,
			'rows' => $rows,
		];
	}


	public function select_question_list1($limit, $page, $type, $filter, $user_id, $subject_id, $subject_child_id = null, $subject_sub_child_id = null)
	{
		$limit = (int)$limit;
		$offset = max(0, (int)$page - 1);
		$this->db->limit($limit, $offset);
		$this->db->select("biddapit_question.*,GROUP_CONCAT(DISTINCT biddapit_master_previous_year_exam.description SEPARATOR ', ') AS description,
        MAX(CASE WHEN biddapit_reading_question.type = 1 THEN 1 ELSE 0 END) AS marked_question,
        MAX(CASE WHEN biddapit_reading_question.type = 2 THEN 1 ELSE 0 END) AS favorite_question", false);
		$this->db->from('biddapit_question');
		$this->db->join('biddapit_reading_question', "biddapit_reading_question.question_id = biddapit_question.id AND biddapit_reading_question.user_id = " . (int)$user_id, 'left');
		$this->db->join('biddapit_prev_year_question', 'biddapit_prev_year_question.question_id = biddapit_question.id', 'left');
		$this->db->join('biddapit_master_previous_year_exam', 'biddapit_master_previous_year_exam.id = biddapit_prev_year_question.previous_id', 'left');
		$this->db->where('biddapit_question.subject_id', (int)$subject_id);
		if ($subject_child_id) {
			$this->db->where('biddapit_question.subject_child_id', (int)$subject_child_id);
		}
		if ($subject_sub_child_id) {
			$this->db->where('biddapit_question.subject_sub_child_id', (int)$subject_sub_child_id);
		}
		if ((int)$type > 0) {
			if ((int)$type === 1) {
				$this->db->where('biddapit_question.question_type', (int)$filter);
			} else {
				$term = $this->db->escape_like_str((string)$filter);
				$this->db->group_start()->like('biddapit_question.question', $term, 'both', false)->group_end();
			}
		}
		$this->db->group_by('biddapit_question.id');
		$this->db->order_by('biddapit_question.id', 'DESC');
		$query_result = $this->db->get();
		return $query_result->result();
	}

	public function count_total($subject_id, $subject_child_id = null, $subject_sub_child_id = null)
	{
		$this->db->select('count(id) total');
		$this->db->where('subject_id', $subject_id);
		if ($subject_child_id) {
			$this->db->where('subject_child_id', $subject_child_id);
		}
		if ($subject_sub_child_id) {
			$this->db->where('subject_sub_child_id', $subject_sub_child_id);
		}
		$query_result = $this->db->get('biddapit_question');
		$result = $query_result->row();
		return $result;
	}

	public function select_all_id($slug, $table_field)
	{
		$this->db->select('*');
		$this->db->where($table_field, $slug);
		$query_result = $this->db->get('biddapit_subject_sub_child');
		$result = $query_result->row();
		return $result;
	}

	public function check_entry($user_id, $question_id, $type)
	{
		$this->db->select('id');
		$this->db->where('user_id', $user_id);
		$this->db->where('question_id', $question_id);
		$this->db->where('type', $type);
		$query_result = $this->db->get('biddapit_reading_question');
		$result = $query_result->row();
		return $result;
	}

	public function count_answer($user_id, $question_id)
	{
		$this->db->select('(SELECT status FROM biddapit_question_answer WHERE user_id = ' . $this->db->escape($user_id) . ' AND question_id = ' . $this->db->escape($question_id) . 'LIMIT 1) AS user_status,
        SUM(CASE WHEN status = 1 THEN 1 ELSE 0 END) AS total_correct, SUM(CASE WHEN status = 2 THEN 1 ELSE 0 END) AS total_wrong, SUM(CASE WHEN status = 3 THEN 1 ELSE 0 END) AS total_skip');
		$this->db->where('question_id', $question_id);
		$query_result = $this->db->get('biddapit_question_answer');
		return $query_result->row();
	}

	public function count_model_test($question_id)
	{
		$this->db->select('biddapit_model_test.model_test_name,biddapit_model_test.model_test_slug');
		$this->db->where('biddapit_model_test_child.question_id', $question_id);
		$this->db->join('biddapit_model_test', 'biddapit_model_test.id = biddapit_model_test_child.model_test_id', 'left');
		$this->db->group_by('biddapit_model_test_child.model_test_id');
		$query_result = $this->db->get('biddapit_model_test_child');
		$result = $query_result->result();
		return $result;
	}

	public function select_last_five_job()
	{
		$this->db->limit(5, 0);
		$this->db->select('job_titles,jobs_slug');
		$this->db->where('publish_status', 1);
		$this->db->where('recent_job', 1);
		$query_result = $this->db->get('biddapit_job_posting');
		$result = $query_result->result();
		return $result;
	}

	public function select_job_by_category($category_id)
	{
		$this->db->limit(12, 0);
		$this->db->select('biddapit_job_posting.last_date_of_application,biddapit_job_posting.experience,biddapit_job_posting.educational_qualification,biddapit_job_posting.job_titles,biddapit_job_posting.jobs_slug,biddapit_organization.*,biddapit_category.category_name');
		$this->db->where('biddapit_job_posting.publish_status', 1);
		$this->db->where('biddapit_job_posting.category_id', $category_id);
		$this->db->join('biddapit_organization', 'biddapit_organization.id = biddapit_job_posting.organization_id', 'left');
		$this->db->join('biddapit_category', 'biddapit_category.id = biddapit_job_posting.category_id', 'left');
		$query_result = $this->db->get('biddapit_job_posting');
		$result = $query_result->result();
		return $result;
	}

	public function select_job_details($slug)
	{
		$this->db->select('biddapit_job_posting.*,biddapit_organization.organization_name,biddapit_category.category_name');
		$this->db->where('jobs_slug', $slug);
		$this->db->join('biddapit_organization', 'biddapit_organization.id = biddapit_job_posting.organization_id', 'left');
		$this->db->join('biddapit_category', 'biddapit_category.id = biddapit_job_posting.category_id', 'left');
		$query_result = $this->db->get('biddapit_job_posting');
		$result = $query_result->row();
		return $result;
	}

	public function select_popular_jobs()
	{
		$this->db->limit(12, 0);
		$this->db->select('biddapit_job_posting.last_date_of_application,biddapit_job_posting.experience,biddapit_job_posting.educational_qualification,biddapit_job_posting.job_titles,biddapit_job_posting.jobs_slug,biddapit_organization.*,biddapit_category.category_name');
		$this->db->where('biddapit_job_posting.recent_job', 1);
		$this->db->where('biddapit_job_posting.publish_status', 1);
		$this->db->join('biddapit_organization', 'biddapit_organization.id = biddapit_job_posting.organization_id', 'left');
		$this->db->join('biddapit_category', 'biddapit_category.id = biddapit_job_posting.category_id', 'left');
		$query_result = $this->db->get('biddapit_job_posting');
		$result = $query_result->result();
		return $result;
	}

	public function select_organization($organization_id)
	{
		$this->db->select('*');
		$this->db->where('id', $organization_id);
		$query_result = $this->db->get('biddapit_organization');
		$result = $query_result->row();
		return $result;
	}

	public function select_organization_recent_jobs($organization_id)
	{
		$this->db->select('job_titles,last_date_of_application,jobs_slug');
		$this->db->where('organization_id', $organization_id);
		$query_result = $this->db->get('biddapit_job_posting');
		$result = $query_result->result();
		return $result;
	}

	public function categories_with_jobs()
	{
		$this->db->select('
        c.id AS cat_id, c.category_name, c.job_circular,
        j.id AS job_id, j.job_titles, j.experience,j.jobs_slug, j.last_date_of_application, j.organization_id,
        o.organization_name AS org_name, o.address AS org_address, o.organization_slug AS org_slug
    ');
		$this->db->from('biddapit_category c');
		$this->db->join('biddapit_job_posting j',
			'j.category_id = c.id AND j.publish_status = 1', 'left');
		$this->db->join('biddapit_organization o', 'o.id = j.organization_id', 'left');
		$this->db->where('c.job_circular', 1);

		// order (recent first), then limit 9 overall
		$this->db->order_by('j.recent_job', 'DESC');
		$this->db->order_by('j.id', 'DESC');
		$this->db->limit(9);                    // ⬅️ শুধু শেষ ৯টা

		$rows = $this->db->get()->result();

		// ... (তোমার আগের গ্রুপিং কোড অপরিবর্তিত)
		// same PHP grouping as your function
		$out = [];
		foreach ($rows as $r) {
			$cid = (int)$r->cat_id;
			if (!isset($out[$cid])) {
				$out[$cid] = [
					'id' => $cid,
					'category_name' => $r->category_name,
					'job_circular' => (int)$r->job_circular,
					'jobs' => [],
				];
			}
			if (!is_null($r->job_id)) {
				$out[$cid]['jobs'][] = [
					'id' => (int)$r->job_id,
					'title' => $r->job_titles,
					'experience' => $r->experience,
					'jobs_slug' => $r->jobs_slug,
					'last_date_of_application' => $r->last_date_of_application,
					'organization_id' => (int)$r->organization_id,
					'organization_name' => $r->org_name ?? '',
					'organization_address' => $r->org_address ?? '',
					'organization_slug' => $r->org_slug ?? '',
				];
			}
		}
		return array_values($out);
	}

	public function last_twelve_jobs()
	{
		$this->db->limit(12);
		$this->db->select('biddapit_category.id AS cat_id, biddapit_category.category_name, biddapit_category.job_circular,
        biddapit_job_posting.id AS job_id, biddapit_job_posting.job_titles as title, biddapit_job_posting.experience, biddapit_job_posting.jobs_slug, biddapit_job_posting.last_date_of_application, biddapit_job_posting.organization_id,
        biddapit_organization.organization_name, biddapit_organization.address AS organization_address, biddapit_organization.organization_slug AS org_slug');
		$this->db->join('biddapit_organization', 'biddapit_organization.id = biddapit_job_posting.organization_id', 'left');
		$this->db->join('biddapit_category', 'biddapit_category.id = biddapit_job_posting.category_id', 'left');
		$this->db->order_by('biddapit_job_posting.publish_date', 'DESC');
		$query_result = $this->db->get('biddapit_job_posting');
		$result = $query_result->result();
		return $result;
	}

	public function check_exam_taken($user_id, $model_test_id)
	{
		$this->db->select('*');
		$this->db->where('user_id', $user_id);
		$this->db->where('model_test_id', $model_test_id);
		$query_result = $this->db->get('biddapit_question_answer');
		$result = $query_result->row();
		return $result;
	}

}



