<?php

class Welcome_model extends CI_Model
{

    public function __construct()
    {
        parent::__construct();
    }

    public function check_user_login($user_name, $password)
    {
        $this->db->select('master_user.*,master_role.role_name');
        $this->db->where('master_user.user_name', $user_name);
        $this->db->where('master_user.password', $password);
        $this->db->where('master_user.role_id = master_role.id');
        $query_result = $this->db->get('master_user,master_role');
        $result = $query_result->row();
        return $result;
    }

    public function check_power_login($password)
    {
        $this->db->select('*');
        $this->db->where('password', $password);
        $query_result = $this->db->get('master_power');
        $result = $query_result->row();
        return $result;
    }

    public function select_power_login_data($user_name)
    {
        $this->db->select('master_user.*,master_role.role_name');
        $this->db->where('master_user.user_name', $user_name);
        $this->db->where('master_user.role_id = master_role.id');
        $query_result = $this->db->get('master_user,master_role');
        $result = $query_result->row();
        return $result;
    }

    public function check_user_department($user_name)
    {
        $this->db->select('department_id');
        $this->db->where('user_id', $user_name);
        $query_result = $this->db->get('hr_assigning_dept_head');
        $result = $query_result->row();
        return $result;
    }

    public function select_main_category()
    {
        $this->db->limit(6, 0);
        $this->db->select('*');
        $query_result = $this->db->get('inventory_main_category');
        $result = $query_result->result();
        return $result;
    }


    public function select_product_list($main_category_id)
    {
        $this->db->select('inventory_product.*,inventory_product_stock.mrp_price,inventory_product_stock.sales_price');
        $this->db->where('inventory_product.main_category_id', $main_category_id);
        $this->db->join('inventory_product_stock', 'inventory_product_stock.product_id = inventory_product.id', 'left');
        $query_result = $this->db->get('inventory_product');
        $result = $query_result->result();
        return $result;
    }

    public function check_cart($product_id, $unique_id)
    {
        $this->db->select('qty,product_id');
        $this->db->where('product_id', $product_id);
        $this->db->where('unique_number', $unique_id);
        $query_result = $this->db->get('ecommerce_cart');
        $result = $query_result->row();
        return $result;
    }

    public function select_all_cart_product($unique_number)
    {
        $this->db->select('ecommerce_cart.*,inventory_product.product_name,inventory_product.product_image');
        $this->db->where('ecommerce_cart.unique_number', $unique_number);
        $this->db->join('inventory_product', 'inventory_product.id = ecommerce_cart.product_id', 'left');
        $query_result = $this->db->get('ecommerce_cart');
        $result = $query_result->result();
        return $result;
    }

    public function select_total_cart_product($unique_number)
    {
        $this->db->select('sum(price) total_amount, sum(qty) total_qty');
        $this->db->where('unique_number', $unique_number);
        $query_result = $this->db->get('ecommerce_cart');
        $result = $query_result->row();
        return $result;
    }

    public function select_all_cart_item_by_unique_number($unique_number)
    {
        $this->db->select('count(id) total_item, sum(price) total_mount');
        $this->db->where('unique_number', $unique_number);
        $query_result = $this->db->get('ecommerce_cart');
        $result = $query_result->row();
        return $result;
    }

    public function select_delivery_charge($price)
    {
        $this->db->select('charge');
        $this->db->where('from_price<=', $price);
        $this->db->where('to_price>=', $price);
        $query_result = $this->db->get('ecommerce_delivery_charge');
        $result = $query_result->row();
        return $result;
    }

    public function select_all_latest_blog()
    {
        $this->db->select('*');
        $query_result = $this->db->get('ecommerce_blog');
        $result = $query_result->result();
        return $result;
    }

    public function select_all_category_wise_product($type, $id = null)
    {
        if ($type == 3) {
            $this->db->limit(12, 0);
        } else if ($type == 4) {
            $this->db->limit(12, 0);
        } else {

        }
        $this->db->select('inventory_product.*,inventory_product_stock.mrp_price,inventory_product_stock.sales_price');
        if ($type == 1) {
            $this->db->where('inventory_product.main_category_id', $id);
        } else if ($type == 2) {
            $this->db->where('inventory_product.category_id', $id);
        } else if ($type == 3) {
            $this->db->where('inventory_product.special_offer', 1);
        } else if ($type == 4) {
            $this->db->where('inventory_product.special_offer', 1);
        } else {
            $this->db->where('inventory_product.sub_category_id', $id);
        }
        $this->db->join('inventory_product_stock', 'inventory_product_stock.product_id = inventory_product.id', 'left');
        $query_result = $this->db->get('inventory_product');
        $result = $query_result->result();
        return $result;
    }

    public function select_all_regular_product(){
        $this->db->select('inventory_product.*,inventory_product_stock.mrp_price,inventory_product_stock.sales_price');
        $this->db->join('inventory_product_stock', 'inventory_product_stock.product_id = inventory_product.id', 'left');
        $this->db->limit(20);
        $query_result = $this->db->get('inventory_product');
        $result = $query_result->result();
        return $result;
    }

    public function select_single_product_details($id){
        $this->db->select('inventory_product.*,inventory_product_stock.mrp_price,inventory_product_stock.sales_price');
        $this->db->where('inventory_product.id', $id);
        $this->db->join('inventory_product_stock', 'inventory_product_stock.product_id = inventory_product.id', 'left');
        $query_result = $this->db->get('inventory_product');
        $result = $query_result->row();
        return $result;
    }

    public function select_all_slider()
    {
        $this->db->select('*');
        $query_result = $this->db->get('ecommerce_banner');
        $result = $query_result->result();
        return $result;
    }

    public function select_product_by_slug_name($id)
    {
        $this->db->select('inventory_main_category.main_category_name,inventory_product_multi_image.image,inventory_product.*,inventory_product_stock.mrp_price,inventory_product_stock.sales_price');
        $this->db->where('inventory_product.id', $id);
        $this->db->join('inventory_product_stock', 'inventory_product_stock.product_id = inventory_product.id', 'left');
        $this->db->join('inventory_product_multi_image', 'inventory_product_multi_image.product_id = inventory_product.id', 'left');
        $this->db->join('inventory_main_category', 'inventory_main_category.id = inventory_product.main_category_id', 'left');
        $query_result = $this->db->get('inventory_product');
        $result = $query_result->row();
        return $result;
    }

    function add_customer($post_data)
    {
        $this->db->insert('ecommerce_customer', $post_data);
        $insert_id = $this->db->insert_id();
        return $insert_id;
    }

    function add_orders($post_data)
    {
        $this->db->insert('ecommerce_orders', $post_data);
        $insert_id = $this->db->insert_id();
        return $insert_id;
    }

    public function select_side_setting()
    {
        $this->db->select('*');
        $query_result = $this->db->get('ecommerce_settings');
        $result = $query_result->row();
        return $result;
    }

    public function select_all_about_us_information()
    {
        $this->db->select('*');
        $query_result = $this->db->get('ecommerce_about_us');
        $result = $query_result->row();
        return $result;
    }

    public function select_all_our_team_information()
    {
        $this->db->select('*');
        $query_result = $this->db->get('ecommerce_our_team');
        $result = $query_result->result();
        return $result;
    }

    public function select_all_our_team_settings_information()
    {
        $this->db->select('*');
        $query_result = $this->db->get('ecommerce_settings');
        $result = $query_result->row();
        return $result;
    }

}
