<?php

class Category extends MX_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('biddapit/Category_model');
	}

	public function index()
	{

	}

	public function all_category()
	{
//		$password = '1234562';
//		$hashedPassword = password_hash($password, PASSWORD_DEFAULT);
//		echo $hashedPassword;
//
//		$enteredPassword = '123456';
//
//		if (password_verify($enteredPassword, $hashedPassword)) {
//			echo "Password is correct!";
//		} else {
//			echo "Invalid password!";
//		}
//
//		exit();

		$this->config->load('pagination');
		$this->load->library("pagination");
		$config = array();
		$config["base_url"] = base_url() . "biddapit/category/all_category";
		$config["total_rows"] = $this->Main_model->countAll('biddapit_category');;
		$config['per_page'] = 20;
		$config['uri_segment'] = 4;
		$config['num_links'] = 2;
		$this->pagination->initialize($config);
		$page = ($this->uri->segment(4)) ? $this->uri->segment(4) : 0;
		$data["category"] = $this->Category_model->select_all_category($config["per_page"], $page);
		$data["links"] = $this->pagination->create_links();
		if ($this->input->is_ajax_request()) {
			$this->load->view('category/per_page_category', $data);
		} else {
			$this->load->view('category/category_tpl', $data);
		}
	}

	public function load_add_category_from()
	{
		$this->load->view('biddapit/category/category_from');
	}

	public function create_category()
	{
		$user_name = $this->session->userdata("user_name");
		$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));
		$data = array(
			'category_name' => $this->input->post('category_name'),
			'model_test' => $this->input->post('model_test'),
			'job_preparation' => $this->input->post('job_preparation'),
			'academic_preparation' => $this->input->post('academic_preparation'),
			'video_courses' => $this->input->post('video_courses'),
			'year_question' => $this->input->post('year_question'),
			'job_circular' => $this->input->post('job_circular'),
			'created_by' => $user_name,
			'remarks' => 'Add',
			'date_and_time' => $dt->format('F j, Y, g:i a')
		);
		$data1 = array();
		if (!empty($_FILES)) {
			$config['upload_path'] = 'public/question_image';
			$config['allowed_types'] = 'jpg|png|docx|doc|pdf';
			$config['max_size'] = 100000;
			$config['max_width'] = 100024;
			$config['max_height'] = 100000;
			$config['file_name'] = date('d-m-Y') . '_' . time();
			$this->load->library('upload', $config);
			if (!$this->upload->do_upload('logo')) {
				$this->upload->display_errors();
			} else {
				$recipe_file = $this->upload->data();
				$file = $recipe_file['file_name'];
				$data1 = array(
					'logo' => $file
				);
			}
		}
		$result = array_merge($data, $data1);
		$this->Main_model->insertData($result, 'biddapit_category');
		if ($result) {
			$msg['load_success_message'] = "Category successfully added.";
			$this->load->view('messages/success_message', $msg);
		}
	}

	public function load_update_category_from($id)
	{
		$data['category'] = $this->Main_model->getValue("id = '$id'", 'biddapit_category', '*', "id desc");
		$this->load->view('biddapit/category/update_category_from', $data);
	}

	public function update_category()
	{
		$id = $this->input->post('id');
		$user_name = $this->session->userdata("user_name");
		$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));
		$text = $this->input->post('category_name');
		$category_slug = preg_replace('/\s+/', '-', $text);
		$data = array(
			'category_name' => $this->input->post('category_name'),
			'category_slug' => $category_slug,
			'model_test' => $this->input->post('model_test'),
			'job_preparation' => $this->input->post('job_preparation'),
			'academic_preparation' => $this->input->post('academic_preparation'),
			'video_courses' => $this->input->post('video_courses'),
			'year_question' => $this->input->post('year_question'),
			'job_circular' => $this->input->post('job_circular'),
			'created_by' => $user_name,
			'remarks' => 'Update',
			'date_and_time' => $dt->format('F j, Y, g:i a')
		);
		$data1 = array();
		$data2 = array();
		$data3 = array();
		if (!empty($_FILES)) {
			$config['upload_path'] = 'public/question_image';
			$config['allowed_types'] = 'jpg|png|docx|doc|pdf';
			$config['max_size'] = 100000;
			$config['max_width'] = 100024;
			$config['max_height'] = 100000;
			$config['file_name'] = date('d-m-Y') . '_' . time();
			$this->load->library('upload', $config);
			if (!$this->upload->do_upload('logo')) {
				echo $this->upload->display_errors();
			} else {
				$recipe_file = $this->upload->data();
				$file = $recipe_file['file_name'];
				$data1 = array(
					'logo' => $file
				);
			}
		}

		if (!empty($_FILES)) {
			$config['upload_path'] = 'public/question_image';
			$config['allowed_types'] = 'jpg|png|docx|doc|pdf';
			$config['max_size'] = 100000;
			$config['max_width'] = 100024;
			$config['max_height'] = 100000;
			$config['file_name'] = date('d-m-Y') . '_' . time();
			$this->load->library('upload', $config);
			if (!$this->upload->do_upload('banner_web')) {
				echo $this->upload->display_errors();
			} else {
				$recipe_file = $this->upload->data();
				$file = $recipe_file['file_name'];
				$data2 = array(
					'banner_web' => $file
				);
			}
		}
		if (!empty($_FILES)) {
			$config['upload_path'] = 'public/question_image';
			$config['allowed_types'] = 'jpg|png|docx|doc|pdf';
			$config['max_size'] = 100000;
			$config['max_width'] = 100024;
			$config['max_height'] = 100000;
			$config['file_name'] = date('d-m-Y') . '_' . time();
			$this->load->library('upload', $config);
			if (!$this->upload->do_upload('banner_mobile')) {
				echo $this->upload->display_errors();
			} else {
				$recipe_file = $this->upload->data();
				$file = $recipe_file['file_name'];
				$data3 = array(
					'banner_mobile' => $file
				);
			}
		}
		$result = array_merge($data, $data1, $data2, $data3);
		$this->Main_model->updateData($result, "biddapit_category", "id='$id'");
		if ($result) {
			$msg['load_success_message'] = "Category update successfully.";
			$this->load->view('messages/success_message', $msg);
		}
	}
}

?>
