<?php

class Create_model_test extends MX_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('biddapit/Create_model_test_model');
		$this->load->model('biddapit/Question_model');
	}

	public function home()
	{
		$this->config->load('pagination');
		$this->load->library("pagination");
		$config = array();
		$config["base_url"] = base_url() . "biddapit/create_model_test/home";
		$config["total_rows"] = $this->Main_model->countAll('biddapit_question');;
		$config['per_page'] = 20;
		$config['uri_segment'] = 4;
		$config['num_links'] = 2;
		$this->pagination->initialize($config);
		$page = ($this->uri->segment(4)) ? $this->uri->segment(4) : 0;
		$data["question"] = $this->Create_model_test_model->select_all_question($config["per_page"], $page);
		$data["links"] = $this->pagination->create_links();
		$data['category'] = $this->Main_model->getValue("model_test = '1'", 'biddapit_category', '*', "id desc");
		$data['subject'] = $this->Main_model->getValue("", 'biddapit_subject', '*', "id desc");
		$data['year'] = $this->Main_model->getValue("", 'master_year', '*', "id asc");
		$data['exam_no'] = $this->Main_model->getValue("", 'biddapit_exam_no', '*', "id asc");
		if ($this->input->is_ajax_request()) {
			$this->load->view('create_model_test/per_page_create_model_test', $data);
		} else {
			$this->load->view('create_model_test/create_model_test_tpl', $data);
		}
	}

	public function model_test_create()
	{
		$user_name = $this->session->userdata("user_name");
		$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));
		$text = $this->input->post('model_test_name');
		$slug = preg_replace('/\s+/', '-', $text);
		$category = $this->input->post('category_id');
		$array = explode(',', $category);
		$data = array(
			'model_test_type' => $this->input->post('model_test_type'),
			'category_id' => $array[0],
			'category_slug' => $array[1],
			'course_price' => $this->input->post('course_price'),
			'offer_price' => $this->input->post('offer_price'),
			'total_question' => $this->input->post('total_question'),
			'exam_duration' => $this->input->post('exam_duration'),
			'exam_date' => $this->input->post('exam_date'),
			'model_test_name' => $text,
			'model_test_slug' => $slug,
			'payment_status' => $this->input->post('payment_status'),
			'status' => 2,
			'per_question_right_marks' => $this->input->post('per_question_right_marks'),
			'per_question_wrong_marks' => $this->input->post('per_question_wrong_marks'),
			'year' => $this->input->post('year'),
			'exam_no' => $this->input->post('exam_no'),
			'start' => $this->input->post('start'),
			'end' => $this->input->post('end'),
			'subject_id' => $this->input->post('subject_id'),
			'subject_child_id' => $this->input->post('subject_child_id'),
			'subject_sub_child_id' => $this->input->post('subject_sub_child_id'),
			'created_by' => $user_name,
			'remarks' => "Add",
			'date_and_time' => $dt->format('F j, Y, g:i a'),
		);
		$result = $this->Main_model->insertData($data, 'biddapit_model_test');
		if ($result) {
			$msg['load_success_message'] = "Model test created successfully.";
			$this->load->view('messages/success_message', $msg);
		}
	}

	public function select_subject_child()
	{
		$subject_id = $this->input->post('subject_id');
		$array = $this->Main_model->getValue("subject_id = '$subject_id'", 'biddapit_subject_child', '*', "id desc");
		$str = "";
		$str .= '<select name="subject_child_id" id="subject_child_id" class="form-control">
				<option value="">--- Select Subject Child ---</option>';
		if (!empty($array)) {
			foreach ($array as $row) {
				$str .= '<option value="' . $row->id . '">' . $row->subject_child_name . '</option>';
			}
		}
		$str .= '</select>';
		echo $str;
	}

	public function select_subject_sub_child()
	{
		$subject_id = $this->input->post('subject_id');
		$subject_child_id = $this->input->post('subject_child_id');
		$array = $this->Main_model->getValue("subject_id = '$subject_id' and subject_child_id='$subject_child_id'", 'biddapit_subject_sub_child', '*', "id desc");
		$str = "";
		$str .= '<select name="subject_sub_child_id" id="subject_sub_child_id" class="form-control">
				<option value="">--- Select subject sub child ---</option>';
		if (!empty($array)) {
			foreach ($array as $row) {
				$str .= '<option value="' . $row->id . '">' . $row->subject_sub_child_name . '</option>';
			}
		}
		$str .= '</select>';
		echo $str;
	}

}

?>
