<?php

class Job_posting extends MX_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('biddapit/Job_posting_model');
	}

	public function index()
	{

	}

	public function all_job_posting()
	{
		$this->config->load('pagination');
		$this->load->library("pagination");
		$config = array();


		$job_posting_name = $this->input->post('job_posting_name');
		$release_date = $this->input->post('release_date');
		$application_start_date = $this->input->post('application_start_date');
		$last_date_of_application = $this->input->post('last_date_of_application');

		$config["base_url"] = base_url() . "biddapit/job_posting/all_job_posting";

		if ($job_posting_name) {
			$result = $this->Job_posting_model->count_by_job_posting($job_posting_name);
			$config["total_rows"] = count($result);
		} else if ($release_date) {
			$result = $this->Job_posting_model->count_by_release_date($release_date);
			$config["total_rows"] = count($result);
		} else if ($application_start_date) {
			$result = $this->Job_posting_model->count_by_application_start_date($application_start_date);
			$config["total_rows"] = count($result);
		} else if ($last_date_of_application) {
			$result = $this->Job_posting_model->count_by_last_date_of_application($last_date_of_application);
			$config["total_rows"] = count($result);
		} else {
			$config["total_rows"] = $this->Main_model->countAll('biddapit_job_posting');
		}


		$config['per_page'] = 30;
		$config['uri_segment'] = 4;
		$config['num_links'] = 9;
		$this->pagination->initialize($config);
		$page = ($this->uri->segment(4)) ? $this->uri->segment(4) : 0;

		if ($job_posting_name) {
			$data["job_posting"] = $this->Job_posting_model->select_all_job_posting_by_name($config["per_page"], $page, $job_posting_name);
		} else if ($release_date) {
			$data["job_posting"] = $this->Job_posting_model->select_all_job_posting_by_release_date($config["per_page"], $page, $release_date);
		} else if ($application_start_date) {
			$data["job_posting"] = $this->Job_posting_model->select_all_job_posting_by_application_start_date($config["per_page"], $page, $application_start_date);
		} else if ($last_date_of_application) {
			$data["job_posting"] = $this->Job_posting_model->select_all_job_posting_by_last_date_of_application($config["per_page"], $page, $last_date_of_application);
		} else {
			$data["job_posting"] = $this->Job_posting_model->select_all_job_posting($config["per_page"], $page);
		}

		$data["links"] = $this->pagination->create_links();
		if ($this->input->is_ajax_request()) {
			$this->load->view('job_posting/per_page_job_posting', $data);
		} else {
			$this->load->view('job_posting/job_posting_tpl', $data);
		}
	}

	public function load_add_job_posting_from()
	{
		$data['category'] = $this->Main_model->getValue("job_circular='1'", 'biddapit_category', '*', "ID DESC");
		$data['organization'] = $this->Main_model->getValue("", 'biddapit_organization', '*', "ID DESC");
		$this->load->view('biddapit/job_posting/job_posting_from', $data);
	}

	public function create_job_posting()
	{
		$user_name = $this->session->userdata("user_name");
		$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));
		$id = $this->input->post('id');
		$data = array(
			'publish_status' => $this->input->post('publish_status'),
			'recent_job' => $this->input->post('recent_job'),
			'job_titles' => $this->input->post('job_titles'),
			'jobs_slug' => $this->input->post('jobs_slug'),
			'category_id' => $this->input->post('category_id'),
			'category_slug' =>  $this->input->post('category_slug'),
			'organization_id' => $this->input->post('organization_id'),
			'organization_slug' => $this->input->post('organization_slug'),
			'release_date' => $this->input->post('release_date'),
			'number_of_post' => $this->input->post('number_of_post'),
			'number_of_people' => $this->input->post('number_of_people'),
			'educational_qualification' => $this->input->post('educational_qualification'),
			'age_to_apply' => $this->input->post('age_to_apply'),
			'means_of_application' => $this->input->post('means_of_application'),
			'application_start_date' => $this->input->post('application_start_date'),
			'last_date_of_application' => $this->input->post('last_date_of_application'),
			'official_website' => $this->input->post('official_website'),
			'picture' => $this->input->post('picture'),
			'app_image' => $this->input->post('app_image'),
			'description' => $this->input->post('description'),
			'official_notice' => $this->input->post('official_notice'),
			'app_official_notice' => $this->input->post('app_official_notice'),
			'source_of_job' => $this->input->post('source_of_job'),
			'application_process' => $this->input->post('application_process'),
			'apply_link' => $this->input->post('apply_link'),
			'created_by' => $user_name,
			'remarks' => 'Add',
			'date_and_time' => $dt->format('F j, Y, g:i a')
		);
		$result = $this->Main_model->insertData($data, 'biddapit_job_posting');
		if ($result) {
			$msg['load_success_message'] = "Job posting successfully added.";
			$this->load->view('messages/success_message', $msg);
		}
	}


	public function load_update_job_posting_from()
	{
		$id = $this->input->post('id');
		$data['job_posting'] = $this->Main_model->getValue("id = '$id'", 'biddapit_job_posting', '*', "ID DESC");
		$this->load->view('biddapit/job_posting/update_job_posting_from', $data);
	}


	public function update_job_posting()
	{
		$user_name = $this->session->userdata("user_name");
		$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));
		$id = $this->input->post('id');
		$data = array(
			'publish_status' => $this->input->post('publish_status'),
			'recent_job' => $this->input->post('recent_job'),
			'job_titles' => $this->input->post('job_titles'),
			'jobs_slug' => $this->input->post('jobs_slug'),
			'category_id' => $this->input->post('category_id'),
			'category_slug' => $this->input->post('category_slug'),
			'organization_id' => $this->input->post('organization_id'),
			'organization_slug' => $this->input->post('organization_slug'),
			'release_date' => $this->input->post('release_date'),
			'number_of_post' => $this->input->post('number_of_post'),
			'number_of_people' => $this->input->post('number_of_people'),
			'educational_qualification' => $this->input->post('educational_qualification'),
			'age_to_apply' => $this->input->post('age_to_apply'),
			'means_of_application' => $this->input->post('means_of_application'),
			'application_start_date' => $this->input->post('application_start_date'),
			'last_date_of_application' => $this->input->post('last_date_of_application'),
			'official_website' => $this->input->post('official_website'),
			'picture' => $this->input->post('picture'),
			'app_image' => $this->input->post('app_image'),
			'description' => $this->input->post('description'),
			'official_notice' => $this->input->post('official_notice'),
			'app_official_notice' => $this->input->post('app_official_notice'),
			'source_of_job' => $this->input->post('source_of_job'),
			'application_process' => $this->input->post('application_process'),
			'apply_link' => $this->input->post('apply_link'),
			'created_by' => $user_name,
			'remarks' => 'Update',
			'date_and_time' => $dt->format('F j, Y, g:i a')
		);
		$result = $this->Main_model->updateData($data, "biddapit_job_posting", "id='$id'");
		if ($result) {
			$msg['load_success_message'] = "Job Posting update successfully.";
			$this->load->view('messages/success_message', $msg);
		}
	}

	public function load_details_job_posting_from()
	{
		$id = $this->input->post('id');
		$data['job_posting'] = $this->Job_posting_model->select_job_details_by_id($id);
		$this->load->view('job_posting/job_details', $data);
	}

}

?>
