<?php

class Model_question_add extends MX_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('biddapit/Model_question_add_model');
		$this->load->model('biddapit/Question_model');
	}

	public function all_model_question_add($model_test_id = null)
	{
		$this->config->load('pagination');
		$this->load->library("pagination");
		$config = array();
		$config["base_url"] = base_url() . "biddapit/model_question_add/all_model_question_add";
		$data['model_test_id'] = $model_test_id > 0 ? $model_test_id : $this->input->post('model_test_id');
		$subject_id = $this->input->post('subject_id');
		$child_id = $this->input->post('child_id');
		$sub_child_id = $this->input->post('sub_child_id');
		if (($subject_id) || ($child_id) || ($sub_child_id)) {
			$result = $this->Model_question_add_model->countAllByCondition($subject_id, $child_id, $sub_child_id);
			$config["total_rows"] = count($result);
		} else {
			$config["total_rows"] = $this->Main_model->countAll('biddapit_question');
		}
		$config['per_page'] = 20;
		$config['uri_segment'] = 4;
		$config['num_links'] = 2;
		$this->pagination->initialize($config);
		$page = ($this->uri->segment(4)) ? $this->uri->segment(4) : 0;
		$data["question"] = $this->Model_question_add_model->select_all_question($config["per_page"], $page, $subject_id, $child_id, $sub_child_id);
		$data["links"] = $this->pagination->create_links();
		$data['model_test'] = $this->Model_question_add_model->select_model_test_name();
		$data['previous_year_exam'] = $this->Main_model->getValue("", 'biddapit_master_previous_year_exam', '*', "id desc");
		if ($this->input->is_ajax_request()) {
			$this->load->view('model_question_add/per_page_model_question_add', $data);
		} else {
			$this->load->view('model_question_add/model_question_add_tpl', $data);
		}
	}

	public function add_question()
	{
		$question_id = $this->input->post('question_id');
		$subject_id = $this->input->post('subject_id');
		$model_test_id = $this->input->post('model_test_id');
		$check = $this->Main_model->getValueRow("model_test_id = '$model_test_id' and question_id='$question_id'", 'biddapit_model_test_child', '*', "id desc");
		if ($check) {
			$this->Main_model->deleteData("question_id = '$question_id' and model_test_id='$model_test_id'", "biddapit_model_test_child");
			$count = $this->Model_question_add_model->count_all_question($model_test_id, $subject_id);
			echo $count->total . ",2";
			exit();
		} else {
			$data = array(
				'question_id' => $question_id,
				'subject_id' => $subject_id,
				'model_test_id' => $model_test_id
			);
			$this->Main_model->insertData($data, 'biddapit_model_test_child');
			$count = $this->Model_question_add_model->count_all_question($model_test_id, $subject_id);
			echo $count->total . ",1";
			exit();
		}
	}

	public function generate_random_question()
	{
		$model_test_id = $this->input->post('model_test_id');
		$percent = $this->input->post('percent');
		$syllabus = $this->Model_question_add_model->select_syllabus_by_category($model_test_id);
		foreach ($syllabus as $v_syllabus) {
			$prev_year_question = round(($v_syllabus->total_question * $percent) / 100);
			$others = $v_syllabus->total_question - $prev_year_question;
			$year_question = $this->Model_question_add_model->pick_random_questions_locked($prev_year_question, $v_syllabus->subject_id);
			foreach ($year_question as $v_question) {
				$data_year_question = array(
					'question_id' => $v_question->question_id,
					'subject_id' => $v_syllabus->subject_id,
					'model_test_id' => $model_test_id
				);
				$this->Main_model->insertData($data_year_question, 'biddapit_model_test_child');
			}
			$others_question = $this->Model_question_add_model->pick_random_questions_locked($others, $v_syllabus->subject_id);
			foreach ($others_question as $v_others_question) {
				$data_others_question = array(
					'question_id' => $v_others_question->question_id,
					'subject_id' => $v_syllabus->subject_id,
					'model_test_id' => $model_test_id
				);
				$this->Main_model->insertData($data_others_question, 'biddapit_model_test_child');
			}
		}
		echo "Model test created successfully";
		exit();
	}

	public function prev_year_confirmed()
	{
		$model_test_id = $this->input->post('model_test_id');
		$previous_id = $this->input->post('previous_year_exam_id');
		$year_question = $this->Model_question_add_model->select_all_previous_question($previous_id);
		foreach ($year_question as $v_question) {
			$data_year_question = array(
				'question_id' => $v_question->question_id,
				'subject_id' => $v_question->subject_id,
				'model_test_id' => $model_test_id
			);
			$this->Main_model->insertData($data_year_question, 'biddapit_model_test_child');
		}
		echo "Model test created successfully";
		exit();
	}

	public function reset_confirmed()
	{
		$subject_id = $this->input->post('subject_id');
		$data = array('in_use' => 0);
		$this->Main_model->updateData($data, "biddapit_question", "subject_id='$subject_id'");
		echo "Reset successfully.";
		exit();
	}

	public function select_syllabus_question()
	{
		$subject_id = $this->input->post('subject_id');
		$model_test_id = $this->input->post('model_test_id');
		$result = $this->Model_question_add_model->select_syllabus_question($subject_id, $model_test_id);
		echo $result->total_question;
		exit();
	}


	public function check_syllabus()
	{
		$model_test_id = $this->input->post('model_test_id');
		$data['model_test_id'] = $model_test_id;
		$data["syllabus"] = $this->Model_question_add_model->select_syllabus_by_category($model_test_id);
		$this->load->view('model_question_add/syllabus_view', $data);
	}

	public function select_subject_child()
	{
		$subject_id = $this->input->post('subject_id');
		$array = $this->Main_model->getValue("subject_id = '$subject_id'", 'biddapit_subject_child', '*', "id desc");
		$str = "";
		$str .= '<select name="subject_child_id" id="subject_child_id" class="form-control">
				<option value="">--- Select Subject ---</option>';
		if (!empty($array)) {
			foreach ($array as $row) {
				$str .= '<option value="' . $row->id . '">' . $row->subject_child_name . '</option>';
			}
		}
		$str .= '</select>';
		echo $str;
	}

	public function select_subject_sub_child()
	{
		$subject_id = $this->input->post('subject_id');
		$subject_child_id = $this->input->post('subject_child_id');
		$array = $this->Main_model->getValue("subject_id = '$subject_id' and subject_child_id='$subject_child_id'", 'biddapit_subject_sub_child', '*', "id desc");
		$str = "";
		$str .= '<select name="subject_sub_child_id" id="subject_sub_child_id" class="form-control">
				<option value="">--- Select Subject ---</option>';
		if (!empty($array)) {
			foreach ($array as $row) {
				$str .= '<option value="' . $row->id . '">' . $row->subject_sub_child_name . '</option>';
			}
		}
		$str .= '</select>';
		echo $str;
	}

	public function select_subject()
	{
		$model_test_id = $this->input->post('model_test_id');
		$array = $this->Model_question_add_model->select_syllabus_by_category($model_test_id);
		$str = "";
		$str .= '<select name="subject_id" id="subject_id" class="form-control">
				<option value="">--- Select Subject ---</option>';
		if (!empty($array)) {
			foreach ($array as $row) {
				$str .= '<option value="' . $row->subject_id . '">' . $row->subject_name . '</option>';
			}
		}
		$str .= '</select>';
		echo $str;
	}
}

?>
