<?php

class Model_test extends MX_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('biddapit/Model_test_model');
		$this->load->model('biddapit/Question_model');
	}

	public function all_model_test()
	{
		$this->config->load('pagination');
		$this->load->library("pagination");
		$config = array();
		$config["base_url"] = base_url() . "biddapit/model_test/all_model_test";
		$model_test_name = $this->input->post('model_test_name');
		$category_id = $this->input->post('category_id');
		if ($model_test_name) {
			$config["total_rows"] = $this->Main_model->countByLikeCondition("model_test_name", $model_test_name, "biddapit_model_test");
		} else if ($category_id) {
			$config["total_rows"] = $this->Main_model->countByWhereCondition("category_id='$category_id'", 'biddapit_model_test');
		} else {
			$config["total_rows"] = $this->Main_model->countAll('biddapit_model_test');
		}
		$config['per_page'] = 30;
		$config['uri_segment'] = 4;
		$config['num_links'] = 2;
		$this->pagination->initialize($config);
		$page = ($this->uri->segment(4)) ? $this->uri->segment(4) : 0;
		$data["model_test"] = $this->Model_test_model->select_all_model_test($config["per_page"], $page, $model_test_name, $category_id);
		$data['category'] = $this->Main_model->getValue("model_test = '1'", 'biddapit_category', '*', "id desc");
		$data["links"] = $this->pagination->create_links();
		if ($this->input->is_ajax_request()) {
			$this->load->view('model_test/per_page_model_test', $data);
		} else {
			$this->load->view('model_test/model_test_tpl', $data);
		}
	}

	public function load_update_model_test_from()
	{
		$id = $this->input->post('id');
		$data['subject'] = $this->Main_model->getValue("", 'biddapit_subject', '*', "id desc");
		$data['year'] = $this->Main_model->getValue("", 'master_year', '*', "id asc");
		$data['exam_no'] = $this->Main_model->getValue("", 'biddapit_exam_no', '*', "id asc");
		$data['category'] = $this->Main_model->getValue("model_test = '1'", 'biddapit_category', '*', "id desc");
		$data['model_test'] = $this->Main_model->getValue("id = '$id'", 'biddapit_model_test', '*', "id desc");
		$this->load->view('biddapit/model_test/update_model_test_from', $data);
	}

	public function update_model_test()
	{
		$user_name = $this->session->userdata("user_name");
		$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));
		$id = $this->input->post('id');
		$text = $this->input->post('model_test_name');
		$slug = preg_replace('/\s+/', '-', $text);
		$category = $this->input->post('category_id');
		$array = explode(',', $category);
		$data = array(
			'category_id' => $array[0],
			'category_slug' => $array[1],
			'model_test_type' => $this->input->post('model_test_type'),
			'course_price' => $this->input->post('course_price'),
			'offer_price' => $this->input->post('offer_price'),
			'total_question' => $this->input->post('total_question'),
			'exam_duration' => $this->input->post('exam_duration'),
			'exam_date' => $this->input->post('exam_date'),
			'model_test_name' => $text,
			'model_test_slug' => $slug,
			'payment_status' => $this->input->post('payment_status'),
			'status' => 2,
			'per_question_right_marks' => $this->input->post('per_question_right_marks'),
			'per_question_wrong_marks' => $this->input->post('per_question_wrong_marks'),
			'year' => $this->input->post('year'),
			'exam_no' => $this->input->post('exam_no'),
			'start' => $this->input->post('start'),
			'end' => $this->input->post('end'),
			'subject_id' => $this->input->post('subject_id'),
			'subject_child_id' => $this->input->post('subject_child_id'),
			'subject_sub_child_id' => $this->input->post('subject_sub_child_id'),
			'created_by' => $user_name,
			'remarks' => "Update",
			'date_and_time' => $dt->format('F j, Y, g:i a'),
		);
		$result = $this->Main_model->updateData($data, "biddapit_model_test", "id='$id'");
		if ($result) {
			$msg['load_success_message'] = "Model test updated successfully.";
			$this->load->view('messages/success_message', $msg);
		}
	}

	public function delete_single_question()
	{
		$id = $this->input->post('id');
		$result = $this->Main_model->deleteData("id = '$id'", "biddapit_model_test_child");
		if ($result) {
			echo "Done";
			exit();
		}
	}

	public function view_all_question()
	{
		$id = $this->input->post('id');
		$status = $this->Main_model->getValueRow("id = '$id'", 'biddapit_model_test', 'confirmed_status', "id desc");
		$data['status'] = $status->confirmed_status;
		$data['question'] = $this->Model_test_model->view_all_question($id);
		$this->load->view('biddapit/model_test/view_all_question', $data);
	}

	public function change_status()
	{
		$id = $this->input->post('id');
		$status = $this->input->post('status');
		$data = array(
			'status' => $status,
		);
		$result = $this->Main_model->updateData($data, "biddapit_model_test", "id='$id'");
		if ($result) {
			echo "Done";
			exit();
		}
	}

	public function change_confirmed_status()
	{
		$id = $this->input->post('id');
		$status = $this->input->post('status');
		$data = array(
			'confirmed_status' => $status,
		);
		$result = $this->Main_model->updateData($data, "biddapit_model_test", "id='$id'");
		if ($result) {
			echo "Done";
			exit();
		}
	}

	public function select_subject_child()
	{
		$subject_id = $this->input->post('subject_id');
		$array = $this->Main_model->getValue("subject_id = '$subject_id'", 'biddapit_subject_child', '*', "id desc");
		$str = "";
		$str .= '<select name="subject_child_id" id="subject_child_id" class="form-control">
				<option value="">--- Select Subject Child ---</option>';
		if (!empty($array)) {
			foreach ($array as $row) {
				$str .= '<option value="' . $row->id . '">' . $row->subject_child_name . '</option>';
			}
		}
		$str .= '</select>';
		echo $str;
	}

	public function select_subject_sub_child()
	{
		$subject_id = $this->input->post('subject_id');
		$subject_child_id = $this->input->post('subject_child_id');
		$array = $this->Main_model->getValue("subject_id = '$subject_id' and subject_child_id='$subject_child_id'", 'biddapit_subject_sub_child', '*', "id desc");
		$str = "";
		$str .= '<select name="subject_sub_child_id" id="subject_sub_child_id" class="form-control">
				<option value="">--- Select subject sub child ---</option>';
		if (!empty($array)) {
			foreach ($array as $row) {
				$str .= '<option value="' . $row->id . '">' . $row->subject_sub_child_name . '</option>';
			}
		}
		$str .= '</select>';
		echo $str;
	}

}

?>
