<?php

class Model_test_syllabus extends MX_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('biddapit/Model_test_syllabus_model');
	}

	public function index()
	{

	}

	public function all_model_test_syllabus()
	{
		$this->config->load('pagination');
		$this->load->library("pagination");
		$config = array();
		$config["base_url"] = base_url() . "biddapit/model_test_syllabus/all_model_test_syllabus";
		$type = $this->input->post('type');
		$category_id = $this->input->post('category_id');
		$subject_id = $this->input->post('subject_id');
		if (($type) || ($category_id) || ($subject_id)) {
			$result = $this->Model_test_syllabus_model->countAllByCondition($type, $category_id, $subject_id);
			$config["total_rows"] = count($result);
		} else {
			$config["total_rows"] = $this->Main_model->countAll('biddapit_model_test_syllabus');
		}
		$config['per_page'] = 30;
		$config['uri_segment'] = 4;
		$config['num_links'] = 2;
		$this->pagination->initialize($config);
		$page = ($this->uri->segment(4)) ? $this->uri->segment(4) : 0;
		$data["syllabus"] = $this->Model_test_syllabus_model->select_all_model_test_syllabus($config["per_page"], $page, $type, $category_id, $subject_id);
		$data["links"] = $this->pagination->create_links();
		$data['category'] = $this->Main_model->getValue("model_test='1'", 'biddapit_category', '*', "id desc");
		$data['subject'] = $this->Main_model->getValue("", 'biddapit_subject', '*', "id desc");
		if ($this->input->is_ajax_request()) {
			$this->load->view('model_test_syllabus/per_page_model_test_syllabus', $data);
		} else {
			$this->load->view('model_test_syllabus/model_test_syllabus_tpl', $data);
		}
	}

	public function load_add_model_test_syllabus_from()
	{
		$data['category'] = $this->Main_model->getValue("model_test='1'", 'biddapit_category', '*', "id desc");
		$data['subject'] = $this->Main_model->getValue("", 'biddapit_subject', '*', "id desc");
		$this->load->view('biddapit/model_test_syllabus/model_test_syllabus_from', $data);
	}

	public function create_model_test_syllabus()
	{
		$user_name = $this->session->userdata("user_name");
		$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));
		$data = array(
			'type' => $this->input->post('type'),
			'total_question' => $this->input->post('total_question'),
			'category_id' => $this->input->post('category_id'),
			'subject_id' => $this->input->post('subject_id'),
			'subject_child_id' => $this->input->post('subject_child_id'),
			'subject_sub_child_id' => $this->input->post('subject_sub_child_id'),
			'created_by' => $user_name,
			'remarks' => 'Add',
			'date_and_time' => $dt->format('F j, Y, g:i a')
		);
		$result = $this->Main_model->insertData($data, 'biddapit_model_test_syllabus');
		if ($result) {
			$msg['load_success_message'] = "Model test syllabus successfully added.";
			$this->load->view('messages/success_message', $msg);
		}
	}

	public function load_update_syllabus_from($id)
	{
		$data['category'] = $this->Main_model->getValue("model_test='1'", 'biddapit_category', '*', "id desc");
		$data['subject'] = $this->Main_model->getValue("", 'biddapit_subject', '*', "id desc");
		$data['syllabus'] = $this->Main_model->getValue("id = '$id'", 'biddapit_model_test_syllabus', '*', "id desc");
		$this->load->view('biddapit/model_test_syllabus/update_model_test_syllabus_from', $data);
	}

	public function update_model_test_syllabus()
	{
		$id = $this->input->post('id');
		$user_name = $this->session->userdata("user_name");
		$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));
		$data = array(
			'type' => $this->input->post('type'),
			'total_question' => $this->input->post('total_question'),
			'category_id' => $this->input->post('category_id'),
			'subject_id' => $this->input->post('subject_id'),
			'subject_child_id' => $this->input->post('subject_child_id'),
			'subject_sub_child_id' => $this->input->post('subject_sub_child_id'),
			'created_by' => $user_name,
			'remarks' => 'Update',
			'date_and_time' => $dt->format('F j, Y, g:i a')
		);
		$result = $this->Main_model->updateData($data, "biddapit_model_test_syllabus", "id='$id'");
		if ($result) {
			$msg['load_success_message'] = "Syllabus update successfully.";
			$this->load->view('messages/success_message', $msg);
		}
	}

	public function select_subject_child()
	{
		$subject_id = $this->input->post('subject_id');
		$array = $this->Main_model->getValue("subject_id = '$subject_id'", 'biddapit_subject_child', '*', "id desc");
		$str = "";
		$str .= '<select name="subject_child_id" id="subject_child_id" class="form-control">
				<option value="">--- Select Subject ---</option>';
		if (!empty($array)) {
			foreach ($array as $row) {
				$str .= '<option value="' . $row->id . '">' . $row->subject_child_name . '</option>';
			}
		}
		$str .= '</select>';
		echo $str;
	}

	public function select_subject_sub_child()
	{
		$subject_id = $this->input->post('subject_id');
		$subject_child_id = $this->input->post('subject_child_id');
		$array = $this->Main_model->getValue("subject_id = '$subject_id' and subject_child_id='$subject_child_id'", 'biddapit_subject_sub_child', '*', "id desc");
		$str = "";
		$str .= '<select name="subject_sub_child_id" id="subject_sub_child_id" class="form-control">
				<option value="">--- Select Subject ---</option>';
		if (!empty($array)) {
			foreach ($array as $row) {
				$str .= '<option value="' . $row->id . '">' . $row->subject_sub_child_name . '</option>';
			}
		}
		$str .= '</select>';
		echo $str;
	}


}

?>
