<?php

class Organization extends MX_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('biddapit/Organization_Model');
	}

	public function index()
	{

	}

	public function all_organization()
	{
		$this->config->load('pagination');
		$this->load->library("pagination");
		$config = array();
		$organization_name = $this->input->post('organization_name');
		$address = $this->input->post('address');
		$config["base_url"] = base_url() . "biddapit/organization/all_organization";

		if ($organization_name) {
			$result = $this->Organization_Model->count_by_organization_name($organization_name);
			$config["total_rows"] = count($result);
		}else if($address){
			$result = $this->Organization_Model->count_by_address_name($address);
			$config["total_rows"] = count($result);
		} else {
			$config["total_rows"] = $this->Main_model->countAll('biddapit_organization');
		}

		$config['per_page'] = 30;
		$config['uri_segment'] = 4;
		$config['num_links'] = 9;
		$this->pagination->initialize($config);
		$page = ($this->uri->segment(4)) ? $this->uri->segment(4) : 0;

		if ($organization_name) {
			$data["organization"] = $this->Organization_Model->select_all_organization_by_name($config["per_page"], $page, $organization_name);
		}else if($address){
			$data["organization"] = $this->Organization_Model->select_all_address_name($config["per_page"], $page, $address);
		} else {
			$data["organization"] = $this->Organization_Model->select_all_organization($config["per_page"], $page);
		}
		$data["links"] = $this->pagination->create_links();
		if ($this->input->is_ajax_request()) {
			$this->load->view('organization/per_page_organization', $data);
		} else {
			$this->load->view('organization/organization_tpl', $data);
		}
	}

	public function load_add_organization_from()
	{
		$this->load->view('biddapit/organization/organization_from');
	}

	public function create_organization()
	{
		$data = array(
			'organization_name' => $this->input->post('organization_name'),
			'organization_slug' => $this->input->post('organization_slug'),
			'address' => $this->input->post('address'),
			'business' => $this->input->post('business')
		);
		$result = $this->Main_model->insertData($data, 'biddapit_organization');
		if ($result) {
			$msg['load_success_message'] = "Organization successfully added.";
			$this->load->view('messages/success_message', $msg);
		}
	}


	public function load_update_organization_from()
	{
		$id = $this->input->post('id');
		$data['organization'] = $this->Main_model->getValue("id = '$id'", 'biddapit_organization', '*', "ID DESC");
		$this->load->view('biddapit/organization/update_organization_from', $data);
	}

	public function update_organization()
	{
		$id = $this->input->post('id');
		$data = array(
			'organization_name' => $this->input->post('organization_name'),
			'organization_slug' => $this->input->post('organization_slug'),
			'address' => $this->input->post('address'),
			'business' => $this->input->post('business'),
		);
		$result = $this->Main_model->updateData($data, "biddapit_organization", "id='$id'");
		if ($result) {
			$msg['load_success_message'] = "Organization update successfully.";
			$this->load->view('messages/success_message', $msg);
		}
	}
}

?>
