<?php

class Previous_year_exam extends MX_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('biddapit/Previous_year_exam_model');
	}

	public function index()
	{

	}

	public function all_previous_year_exam()
	{
		$this->config->load('pagination');
		$this->load->library("pagination");
		$config = array();
		$config["base_url"] = base_url() . "biddapit/previous_year_exam/all_previous_year_exam";
		$config["total_rows"] = $this->Main_model->countAll('biddapit_master_previous_year_exam');;
		$config['per_page'] = 20;
		$config['uri_segment'] = 4;
		$config['num_links'] = 2;
		$this->pagination->initialize($config);
		$page = ($this->uri->segment(4)) ? $this->uri->segment(4) : 0;
		$data["previous_year_exam"] = $this->Previous_year_exam_model->select_all_previous_year_exam($config["per_page"], $page);
		$data["links"] = $this->pagination->create_links();
		if ($this->input->is_ajax_request()) {
			$this->load->view('previous_year_exam/per_page_previous_year_exam', $data);
		} else {
			$this->load->view('previous_year_exam/previous_year_exam_tpl', $data);
		}
	}

	public function load_add_previous_year_exam_from()
	{
		$data['category'] = $this->Main_model->getValue("", 'biddapit_category', '*', "id desc");
		$this->load->view('biddapit/previous_year_exam/previous_year_exam_from', $data);
	}

	public function create_previous_year_exam()
	{
		$user_name = $this->session->userdata("user_name");
		$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));
		$data = array(
			'description' => $this->input->post('description'),
			'category_id' => $this->input->post('category_id'),
			'created_by' => $user_name,
			'remarks' => 'Add',
			'date_and_time' => $dt->format('F j, Y, g:i a')
		);
		$result = $this->Main_model->insertData($data, 'biddapit_master_previous_year_exam');
		if ($result) {
			$msg['load_success_message'] = "Previous year exam successfully added.";
			$this->load->view('messages/success_message', $msg);
		}
	}

	public function load_update_previous_year_exam_from($id)
	{
		$data['category'] = $this->Main_model->getValue("", 'biddapit_category', '*', "id desc");
		$data['previous_year_exam'] = $this->Main_model->getValue("id = '$id'", 'biddapit_master_previous_year_exam', '*', "id desc");
		$this->load->view('biddapit/previous_year_exam/update_previous_year_exam_from', $data);
	}

	public function update_previous_year_exam()
	{
		$id = $this->input->post('id');
		$user_name = $this->session->userdata("user_name");
		$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));
		$data = array(
			'description' => $this->input->post('description'),
			'category_id' => $this->input->post('category_id'),
			'created_by' => $user_name,
			'remarks' => 'Update',
			'date_and_time' => $dt->format('F j, Y, g:i a')
		);
		$result = $this->Main_model->updateData($data, "biddapit_master_previous_year_exam", "id='$id'");
		if ($result) {
			$msg['load_success_message'] = "Previous year exam update successfully.";
			$this->load->view('messages/success_message', $msg);
		}
	}
}

?>
