<?php

class Question extends MX_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('biddapit/Question_model');
	}

	public function index()
	{

	}

	public function all_question()
	{
		$this->config->load('pagination');
		$this->load->library("pagination");
		$config = array();
		$config["base_url"] = base_url() . "biddapit/question/all_question";
		$config["total_rows"] = $this->Main_model->countAll('biddapit_question');;
		$config['per_page'] = 30;
		$config['uri_segment'] = 4;
		$config['num_links'] = 2;
		$this->pagination->initialize($config);
		$page = ($this->uri->segment(4)) ? $this->uri->segment(4) : 0;
		$data["question"] = $this->Question_model->select_all_question($config["per_page"], $page);
		$data["links"] = $this->pagination->create_links();
		if ($this->input->is_ajax_request()) {
			$this->load->view('question/per_page_question', $data);
		} else {
			$this->load->view('question/question_tpl', $data);
		}
	}

	public function load_uddipok_question_from()
	{
		$data['question_id'] = $this->input->post('id');
		$this->load->view('create_question/uddipok_question_from', $data);
	}

	public function create_uddipok_question()
	{
		$status = $this->input->post('status');
		$text = $this->input->post('question');
		$question_status = $this->input->post('question_status');
		$ignore_question_validation = $this->input->post('ignore_question_validation');
		$result = $this->Question_model->check_question_uddipok($text);

		if ($result) {
			if ($ignore_question_validation == 1) {
				$set_check = "";
			} else {
				if ($question_status == 1) {
					$set_check = 1;
				} else {
					$set_check = "";
				}
			}
		} else {
			$set_check = "";
		}

		if ($set_check == 1) {
			echo "This question already added !";
			exit();
		} else {
			$user_name = $this->session->userdata("user_name");
			$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));
			if ($status == 2) {
				$result = "";
			} else {
				$result = preg_replace('/\s+/', '-', $text);
			}

			$data = array(
				'question_id' => $this->input->post('question_id'),
				'status' => $status,
				'question_status' => $question_status,
				'question_slug' => $result,
				'answer_description' => "",
				'description_status' => 0,
				'option_one' => $this->input->post('option_one'),
				'option_two' => $this->input->post('option_two'),
				'option_three' => $this->input->post('option_three'),
				'option_four' => $this->input->post('option_four'),
				'option_five' => $this->input->post('option_five'),
				'option_six' => $this->input->post('option_six'),
				'question_type' => $this->input->post('question_type'),
				'answer' => $this->input->post('answer'),
				'created_by' => $user_name,
				'remarks' => 'Add',
				'date_and_time' => $dt->format('F j, Y, g:i a')
			);
			$data2 = array();
			if (!empty($_FILES)) {
				$config['upload_path'] = 'public/question_image';
				$config['allowed_types'] = 'jpg|png|docx|doc|pdf';
				$config['max_size'] = 100000;
				$config['max_width'] = 100024;
				$config['max_height'] = 100000;
				$config['file_name'] = date('d-m-Y') . '_' . time();
				$this->load->library('upload', $config);
				if (!$this->upload->do_upload('question_image')) {
					echo $this->upload->display_errors();
				} else {
					$recipe_file = $this->upload->data();
					$file = $recipe_file['file_name'];
					$data2 = array(
						'question' => $file
					);
				}
			}

			if ($question_status == 1) {
				$data1 = array(
					'question' => $text,
				);
				$result = array_merge($data, $data1);
			} else {
				$result = array_merge($data, $data2);
			}

			$result1 = $this->Main_model->insertData($result, 'biddapit_question_stimulant');
			if ($result1) {
				$msg['load_success_message'] = "Question created successfully.";
				$this->load->view('messages/success_message', $msg);
			}
		}
	}

	public function create_question_from()
	{
		$data['subject'] = $this->Main_model->getValue("", 'biddapit_subject', '*', "id desc");
		$this->load->view('create_question/create_question_tpl', $data);
	}

	public function create_question()
	{
		$status = $this->input->post('status');
		$text = $this->input->post('question');
		$question_status = $this->input->post('question_status');
		$ignore_question_validation = $this->input->post('ignore_question_validation');
		$result = $this->Question_model->check_question($text);

		if ($result) {
			if ($ignore_question_validation == 1) {
				$set_check = "";
			} else {
				if ($question_status == 1) {
					$set_check = 1;
				} else {
					$set_check = "";
				}
			}
		} else {
			$set_check = "";
		}

		if ($set_check == 1) {
			echo "This question already added !";
			exit();
		} else {
			$user_name = $this->session->userdata("user_name");
			$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));
			if ($status == 2) {
				$result = "";
			} else {
				$result = preg_replace('/\s+/', '-', $text);
			}
			$data = array(
				'subject_id' => $this->input->post('subject_id'),
				'subject_child_id' => $this->input->post('subject_child_id'),
				'subject_sub_child_id' => $this->input->post('subject_sub_child_id'),
				'question_type_status' => $this->input->post('question_type_status'),
				'status' => $status,
				'question_status' => $question_status,
				'question_slug' => $result,
				'answer_description' => "",
				'description_status' => 0,
				'option_one' => $this->input->post('option_one'),
				'option_two' => $this->input->post('option_two'),
				'option_three' => $this->input->post('option_three'),
				'option_four' => $this->input->post('option_four'),
				'option_five' => $this->input->post('option_five'),
				'option_six' => $this->input->post('option_six'),
				'question_type' => $this->input->post('question_type'),
				'answer' => $this->input->post('answer'),
				'created_by' => $user_name,
				'remarks' => 'Add',
				'date_and_time' => $dt->format('F j, Y, g:i a')
			);
			$data2 = array();
			if (!empty($_FILES)) {
				$config['upload_path'] = 'public/question_image';
				$config['allowed_types'] = 'jpg|png|docx|doc|pdf';
				$config['max_size'] = 100000;
				$config['max_width'] = 100024;
				$config['max_height'] = 100000;
				$config['file_name'] = date('d-m-Y') . '_' . time();
				$this->load->library('upload', $config);
				if (!$this->upload->do_upload('question_image')) {
					echo $this->upload->display_errors();
				} else {
					$recipe_file = $this->upload->data();
					$file = $recipe_file['file_name'];
					$data2 = array(
						'question' => $file
					);
				}
			}

			if ($question_status == 1) {
				$data1 = array(
					'question' => $text,
				);
				$result = array_merge($data, $data1);
			} else {
				$result = array_merge($data, $data2);
			}
			$result1 = $this->Main_model->insertData($result, 'biddapit_question');
			if ($result1) {
				$msg['load_success_message'] = "Question created successfully.";
				$this->load->view('messages/success_message', $msg);
			}
		}
	}

	public function add_slug()
	{
		$id = $this->input->post('id');
		$data = array(
			'question_slug' => $this->input->post('question')
		);
		$result = $this->Main_model->updateData($data, "biddapit_question", "id='$id'");
		if ($result) {
			echo "Done";
			exit();
		}
	}

	public function check_question()
	{
		$question = $this->input->post('question');
		$result = $this->Question_model->check_question($question);
		if ($result) {
			echo "1";
			exit();
		} else {
			echo "";
			exit();
		}
	}

	public function check_question_uddipok()
	{
		$question = $this->input->post('question');
		$result = $this->Question_model->check_question_uddipok($question);
		if ($result) {
			echo "1";
			exit();
		} else {
			echo "";
			exit();
		}
	}

	public function load_update_question_from()
	{
		$id = $this->input->post('id');
		$data['subject'] = $this->Main_model->getValue("", 'biddapit_subject', '*', "id desc");
		$data['question'] = $this->Main_model->getValue("id='$id'", 'biddapit_question', '*', "id desc");
		$this->load->view('create_question/update_question', $data);
	}

	public function update_question()
	{
		$id = $this->input->post('id');
		$status = $this->input->post('status');
		$text = $this->input->post('question');
		$ignore_question_validation = $this->input->post('ignore_question_validation');
		$result = $this->Question_model->check_question($text);

		if ($result) {
			if ($ignore_question_validation == 1) {
				$set_check = "";
			} else {
				$set_check = 1;
			}
		} else {
			$set_check = "";
		}

		if ($set_check == 1) {
			echo "This question already added !";
			exit();
		} else {
			$user_name = $this->session->userdata("user_name");
			$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));
			if ($status == 3) {
				$result = "";
			} else {
				$result = preg_replace('/\s+/', '-', $text);
			}
			$data = array(
				'subject_id' => $this->input->post('subject_id'),
				'subject_child_id' => $this->input->post('subject_child_id'),
				'subject_sub_child_id' => $this->input->post('subject_sub_child_id'),
				'question_type_status' => $this->input->post('question_type_status'),
				'status' => $status,
				'question' => $text,
				'question_status' => $this->input->post('question_status'),
				'question_slug' => $result,
				'answer_description' => "",
				'description_status' => 0,
				'option_one' => $this->input->post('option_one'),
				'option_two' => $this->input->post('option_two'),
				'option_three' => $this->input->post('option_three'),
				'option_four' => $this->input->post('option_four'),
				'option_five' => $this->input->post('option_five'),
				'option_six' => $this->input->post('option_six'),
				'question_type' => $this->input->post('question_type'),
				'answer' => $this->input->post('answer'),
				'created_by' => $user_name,
				'remarks' => 'Add',
				'date_and_time' => $dt->format('F j, Y, g:i a')
			);
			$result1 = $this->Main_model->updateData($data, "biddapit_question", "id='$id'");
			if ($result1) {
				$msg['load_success_message'] = "Question updated successfully.";
				$this->load->view('messages/success_message', $msg);
			}
		}
	}

	public function previous_year_question_from()
	{
		$id = $this->input->post('id');
		$data['question_id'] = $id;
		$data['all'] = $this->Question_model->select_previous_year_question($id);
		$data['previous_year'] = $this->Main_model->getValue("", 'biddapit_master_previous_year_exam', '*', "id desc");
		$this->load->view('create_question/previous_year_question_from', $data);
	}

	public function previous_year_question()
	{
		$user_name = $this->session->userdata("user_name");
		$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));
		$question_id = $this->input->post('question_id');
		$previous_id = $this->input->post('previous_id');
		$previous_id_edit = $this->input->post('previous_id_edit');
		if ($previous_id_edit == 0) {
			$data = array(
				'question_id' => $question_id,
				'previous_id' => $previous_id,
				'created_by' => $user_name,
				'remarks' => 'Add',
				'date_and_time' => $dt->format('F j, Y, g:i a')
			);
			$this->Main_model->insertData($data, 'biddapit_prev_year_question');
			$msg['load_success_message'] = "Previous year created successfully.";
		} else {
			$data = array(
				'question_id' => $question_id,
				'previous_id' => $previous_id,
				'created_by' => $user_name,
				'remarks' => 'Add',
				'date_and_time' => $dt->format('F j, Y, g:i a')
			);
			$this->Main_model->updateData($data, "biddapit_prev_year_question", "previous_id='$previous_id_edit' and question_id='$question_id'");
			$msg['load_success_message'] = "Previous year updated successfully.";
		}
		$this->load->view('messages/success_message', $msg);
	}


	public function load_answer_description_uddipok_from()
	{
		$id = $this->input->post('id');
		$data['question_id'] = $id;
		$data['question'] = $this->Main_model->getValue("question_id='$id'", 'biddapit_question_stimulant', 'id,question,question_status', "id asc");
		$this->load->view('create_question/answer_description_uddipok_from', $data);
	}

	public function load_answer_description_from()
	{
		$id = $this->input->post('id');
		$data['question_id'] = $id;
		$data['question'] = $this->Main_model->getValueRow("id='$id'", 'biddapit_question', 'answer_description', "id desc");
		$this->load->view('create_question/answer_description_from', $data);
	}

	public function create_answer_description()
	{
		$user_name = $this->session->userdata("user_name");
		$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));
		$id = $this->input->post('id');
		$type = $this->input->post('type');
		$description = $this->input->post('description');
		$description_multiline = $this->input->post('description_multiline');
		$total_fields = $this->input->post('total_num_of_fields');
		if ($type == 0) {
			$data = array(
				'answer_description' => $description,
			);
			$this->Main_model->updateData($data, "biddapit_question", "id='$id'");
			$msg['load_success_message'] = "Question answer added successfully.";
			$this->load->view('messages/success_message', $msg);
		} else {
			$this->Main_model->deleteData("question_id = '$id'", "biddapit_question_ans_multi_line");
			$data = array(
				'answer_description' => 1,
			);
			$this->Main_model->updateData($data, "biddapit_question", "id='$id'");
			for ($i = 0; $i < $total_fields; $i++) {
				$data = array(
					'question_id' => $id,
					'description' => $description_multiline[$i],
					'created_by' => $user_name,
					'remarks' => 'Add',
					'date_and_time' => $dt->format('F j, Y, g:i a')
				);
				$this->Main_model->insertData($data, 'biddapit_question_ans_multi_line');
			}
			$msg['load_success_message'] = "Question answer added successfully.";
			$this->load->view('messages/success_message', $msg);
		}
	}

	public function create_answer_description_uddipok()
	{
		$user_name = $this->session->userdata("user_name");
		$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));
		$id = $this->input->post('id');
		$type = $this->input->post('type');
		$stimulant_question_id = $this->input->post('stimulant_question_id');
		$description = $this->input->post('description');
		$description_multiline = $this->input->post('description_multiline');
		$total_fields = $this->input->post('total_num_of_fields');
		if ($type == 0) {
			$data = array(
				'answer_description' => $description,
			);
			$this->Main_model->updateData($data, "biddapit_question_stimulant", "id='$stimulant_question_id'");
			$msg['load_success_message'] = "Question answer added successfully.";
			$this->load->view('messages/success_message', $msg);
		} else {
			$this->Main_model->deleteData("question_id = '$id' and stimulant_question_id='$stimulant_question_id'", "biddapit_question_ans_multi_line");
			$data = array(
				'answer_description' => 1,
			);
			$this->Main_model->updateData($data, "biddapit_question_stimulant", "id='$stimulant_question_id'");
			for ($i = 0; $i < $total_fields; $i++) {
				$data = array(
					'question_id' => $id,
					'stimulant_question_id' => $stimulant_question_id,
					'description' => $description_multiline[$i],
					'created_by' => $user_name,
					'remarks' => 'Add',
					'date_and_time' => $dt->format('F j, Y, g:i a')
				);
				$this->Main_model->insertData($data, 'biddapit_question_ans_multi_line');
			}
			$msg['load_success_message'] = "Question answer added successfully.";
			$this->load->view('messages/success_message', $msg);
		}
	}

	public function reset_description()
	{
		$question_id = $this->input->post('id');
		$this->Main_model->deleteData("question_id = '$question_id'", "biddapit_question_ans_multi_line");
		$data = array(
			'answer_description' => "",
		);
		$this->Main_model->updateData($data, "biddapit_question", "id='$question_id'");
		$msg['load_success_message'] = "Question answer reset successfully.";
		$this->load->view('messages/success_message', $msg);
	}

	public function delete_single_line()
	{
		$id = $this->input->post('id');
		$this->Main_model->deleteData("id = '$id'", "biddapit_question_ans_multi_line");
		$msg['load_success_message'] = "Question answer deleted successfully.";
		$this->load->view('messages/success_message', $msg);
	}

	public function edit_uddipak_question_answer_from()
	{
		$stimulant_question_id = $this->input->post('stimulant_question_id');
		$question_id = $this->input->post('question_id');
		$data['question_id'] = $question_id;
		$data['stimulant_question_id'] = $stimulant_question_id;
		$data['update'] = $this->Main_model->getValueRow("id='$stimulant_question_id'", 'biddapit_question_stimulant', '*', "id asc");
		$data['question'] = $this->Main_model->getValue("question_id='$question_id'", 'biddapit_question_stimulant', 'id,question,question_status', "id asc");
		$this->load->view('create_question/edit_uddipak_question_answer', $data);
	}

	public function edit_uddipak_question_from()
	{
		$stimulant_question_id = $this->input->post('stimulant_question_id');
		$question_id = $this->input->post('question_id');
		$data['question_id'] = $question_id;
		$data['stimulant_question_id'] = $stimulant_question_id;
		$data['update'] = $this->Main_model->getValueRow("id='$stimulant_question_id'", 'biddapit_question_stimulant', '*', "id asc");
		$data['question'] = $this->Main_model->getValue("question_id='$question_id'", 'biddapit_question_stimulant', 'id,question,question_status', "id asc");
		$this->load->view('create_question/edit_uddipak_question', $data);
	}

	public function update_uddipok_question()
	{
		$id = $this->input->post('id');
		$status = $this->input->post('status');
		$text = $this->input->post('question');
		$question_status = $this->input->post('question_status');

		$user_name = $this->session->userdata("user_name");
		$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));
		if ($status == 2) {
			$result = "";
		} else {
			$result = preg_replace('/\s+/', '-', $text);
		}

		$data = array(
			'question_id' => $this->input->post('question_id'),
			'status' => $status,
			'question_status' => $question_status,
			'question_slug' => $result,
			'answer_description' => $this->input->post('answer_description'),
			'description_status' => 0,
			'option_one' => $this->input->post('option_one'),
			'option_two' => $this->input->post('option_two'),
			'option_three' => $this->input->post('option_three'),
			'option_four' => $this->input->post('option_four'),
			'option_five' => $this->input->post('option_five'),
			'option_six' => $this->input->post('option_six'),
			'question_type' => $this->input->post('question_type'),
			'answer' => $this->input->post('answer'),
			'created_by' => $user_name,
			'remarks' => 'Add',
			'date_and_time' => $dt->format('F j, Y, g:i a')
		);
		$data2 = array();
		if (!empty($_FILES)) {
			$config['upload_path'] = 'public/question_image';
			$config['allowed_types'] = 'jpg|png|docx|doc|pdf';
			$config['max_size'] = 100000;
			$config['max_width'] = 100024;
			$config['max_height'] = 100000;
			$config['file_name'] = date('d-m-Y') . '_' . time();
			$this->load->library('upload', $config);
			if (!$this->upload->do_upload('question_image')) {
				$this->upload->display_errors();
			} else {
				$recipe_file = $this->upload->data();
				$file = $recipe_file['file_name'];
				$data2 = array(
					'question' => $file
				);
			}
		}
		if ($question_status == 1) {
			$data1 = array(
				'question' => $text,
			);
			$result = array_merge($data, $data1);
		} else {
			$result = array_merge($data, $data2);
		}
		$result1 = $this->Main_model->updateData($result, "biddapit_question_stimulant", "id='$id'");
		if ($result1) {
			$msg['load_success_message'] = "Question updated successfully.";
			$this->load->view('messages/success_message', $msg);
		}
	}

	public function load_slug_for_image_question_from()
	{
		$id = $this->input->post('id');
		$data['id'] = $this->input->post('id');
		$data['question'] = $this->Main_model->getValueRow("id='$id'", 'biddapit_question', 'question', "id asc");
		$this->load->view('create_question/slug_for_image_question', $data);
	}

	public function create_slug_for_image_question()
	{
		$id = $this->input->post('id');
		$data = array(
			'question_slug' => $this->input->post('question_slug'),
		);
		$result1 = $this->Main_model->updateData($data, "biddapit_question", "id='$id'");
		if ($result1) {
			$msg['load_success_message'] = "Question slug created successfully.";
			$this->load->view('messages/success_message', $msg);
		}
	}

	public function select_subject_child()
	{
		$subject_id = $this->input->post('subject_id');
		$array = $this->Main_model->getValue("subject_id = '$subject_id'", 'biddapit_subject_child', '*', "id desc");
		$str = "";
		$str .= '<select name="subject_child_id" id="subject_child_id" class="form-control">
				<option value="">--- Select subject child ---</option>';
		if (!empty($array)) {
			foreach ($array as $row) {
				$str .= '<option value="' . $row->id . '">' . $row->subject_child_name . '</option>';
			}
		}
		$str .= '</select>';
		echo $str;
	}

	public function select_subject_sub_child()
	{
		$subject_child_id = $this->input->post('subject_child_id');
		$array = $this->Main_model->getValue("subject_child_id = '$subject_child_id'", 'biddapit_subject_sub_child', '*', "id desc");
		$str = "";
		$str .= '<select name="subject_sub_child_id" id="subject_sub_child_id" class="form-control">
				<option value="">--- Select subject sub child ---</option>';
		if (!empty($array)) {
			foreach ($array as $row) {
				$str .= '<option value="' . $row->id . '">' . $row->subject_sub_child_name . '</option>';
			}
		}
		$str .= '</select>';
		echo $str;
	}
}

?>
