<?php

class sub_category extends MX_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('biddapit/Sub_category_model');

	}

	public function index()
	{

	}

	public function all_sub_category()
	{
		$this->config->load('pagination');
		$this->load->library("pagination");
		$config = array();
		$sub_category_name = $this->input->post('sub_category_name');
		$category_id = $this->input->post('category_id');
		$config["base_url"] = base_url() . "biddapit/sub_category/all_sub_category";
		if ($sub_category_name) {
			$config["total_rows"] = $this->Main_model->countByLikeCondition("sub_category_name", $sub_category_name, "biddapit_sub_category");
		} else if ($category_id) {
			$config["total_rows"] = $this->Main_model->countByWhereCondition("category_id = '$category_id'", "biddapit_sub_category");;
		} else {
			$config["total_rows"] = $this->Main_model->countAll('biddapit_sub_category');
		}
		$config['per_page'] = 20;
		$config['uri_segment'] = 4;
		$config['num_links'] = 2;
		$this->pagination->initialize($config);
		$page = ($this->uri->segment(4)) ? $this->uri->segment(4) : 0;
		if ($sub_category_name) {
			$data["sub_category"] = $this->Sub_category_model->select_all_sub_category_by_name($config["per_page"], $page, $sub_category_name);
		} else if ($category_id) {
			$data["sub_category"] = $this->Sub_category_model->select_all_sub_category_by_category_id($config["per_page"], $page, $category_id);
		} else {
			$data["sub_category"] = $this->Sub_category_model->select_all_sub_category($config["per_page"], $page);
		}
		$data["links"] = $this->pagination->create_links();
		if ($this->input->is_ajax_request()) {
			$this->load->view('sub_category/per_page_sub_category', $data);
		} else {
			$data['category'] = $this->Main_model->getValue("", 'biddapit_category', '*', "ID DESC");
			$this->load->view('sub_category/sub_category_tpl', $data);
		}
	}

	public function load_add_sub_category_from()
	{
		$data['category'] = $this->Main_model->getValue("", 'biddapit_category', '*', "ID DESC");
		$this->load->view('biddapit/sub_category/sub_category_from', $data);
	}

	public function create_sub_category()
	{
		$user_name = $this->session->userdata("user_name");
		$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));
		$data = array(
			'category_id' => $this->input->post('category_id'),
			'sub_category_name' => $this->input->post('sub_category_name'),
			'created_by' => $user_name,
			'remarks' => 'Add',
			'date_and_time' => $dt->format('F j, Y, g:i a')
		);
		$result = $this->Main_model->insertData($data, 'biddapit_sub_category');
		if ($result) {
			$msg['load_success_message'] = "Sub category successfully added.";
			$this->load->view('messages/success_message', $msg);
		}
	}

	public function load_update_sub_category_from($id)
	{
		$data['category'] = $this->Main_model->getValue("", 'biddapit_category', '*', "id desc");
		$data['sub_category'] = $this->Main_model->getValue("id = '$id'", 'biddapit_sub_category', '*', "id desc");
		$this->load->view('biddapit/sub_category/update_sub_category_from', $data);
	}

	public function update_sub_category()
	{
		$user_name = $this->session->userdata("user_name");
		$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));
		$id = $this->input->post('id');
		$data = array(
			'category_id' => $this->input->post('category_id'),
			'sub_category_name' => $this->input->post('sub_category_name'),
			'created_by' => $user_name,
			'remarks' => 'Update',
			'date_and_time' => $dt->format('F j, Y, g:i a')
		);
		$result = $this->Main_model->updateData($data, "biddapit_sub_category", "id='$id'");
		if ($result) {
			$msg['load_success_message'] = "Sub Category update successfully.";
			$this->load->view('messages/success_message', $msg);
		}
	}

	public function check_duplicate_data($sub_category_name, $category_id)
	{
		$set_data = urldecode($sub_category_name);
		$result = $this->Sub_category_model->check_duplicate_data($set_data, $category_id);
		if ($result) {
			echo "<p style='color: red; font-size: 16px;'>This subcategory name already exit !!!</p>";
			exit();
		} else {
			echo "";
			exit();
		}
	}
}

?>
