<?php

class Subject extends MX_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('biddapit/Subject_model');
	}

	public function index()
	{

	}

	public function all_subject()
	{
		$this->config->load('pagination');
		$this->load->library("pagination");
		$config = array();
		$config["base_url"] = base_url() . "biddapit/subject/all_subject";
		$config["total_rows"] = $this->Main_model->countAll('biddapit_subject');;
		$config['per_page'] = 20;
		$config['uri_segment'] = 4;
		$config['num_links'] = 2;
		$this->pagination->initialize($config);
		$page = ($this->uri->segment(4)) ? $this->uri->segment(4) : 0;
		$data["subject"] = $this->Subject_model->select_all_subject($config["per_page"], $page);
		$data["links"] = $this->pagination->create_links();
		if ($this->input->is_ajax_request()) {
			$this->load->view('subject/per_page_subject', $data);
		} else {
			$this->load->view('subject/subject_tpl', $data);
		}
	}

	public function load_add_subject_from()
	{
		$this->load->view('biddapit/subject/subject_from');
	}

	public function create_subject()
	{
		$user_name = $this->session->userdata("user_name");
		$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));
		$text = $this->input->post('subject_name');
		$slug = $this->make_slug($text);
		$data = array(
			'subject_name' => $text,
			'subject_slug' => $slug,
			'question_limit' => $this->input->post('question_limit'),
			'job' => $this->input->post('job'),
			'five' => $this->input->post('five'),
			'six' => $this->input->post('six'),
			'seven' => $this->input->post('seven'),
			'eight' => $this->input->post('eight'),
			'nine' => $this->input->post('nine'),
			'ten' => $this->input->post('ten'),
			'eleven' => $this->input->post('eleven'),
			'twelve' => $this->input->post('twelve'),
			'created_by' => $user_name,
			'remarks' => 'Add',
			'date_and_time' => $dt->format('F j, Y, g:i a')
		);
		$data1 = array();
		if (!empty($_FILES)) {
			$config['upload_path'] = 'public/subject_images';
			$config['allowed_types'] = 'jpg|png|docx|doc|pdf';
			$config['max_size'] = 100000;
			$config['max_width'] = 100024;
			$config['max_height'] = 100000;
			$config['file_name'] = date('d-m-Y') . '_' . time();
			$this->load->library('upload', $config);
			if (!$this->upload->do_upload('subject_image')) {
				echo $this->upload->display_errors();
			} else {
				$recipe_file = $this->upload->data();
				$file = $recipe_file['file_name'];
				$data1 = array(
					'subject_image' => $file
				);
			}
		}
		$result = array_merge($data, $data1);
		$this->Main_model->insertData($result, 'biddapit_subject');
		if ($result) {
			$msg['load_success_message'] = "Subject successfully added.";
			$this->load->view('messages/success_message', $msg);
		}
	}

	public function load_update_subject_from($id)
	{
		$data['category'] = $this->Main_model->getValue("", 'biddapit_category', '*', "id desc");
		$data['subject'] = $this->Main_model->getValue("id = '$id'", 'biddapit_subject', '*', "id desc");
		$this->load->view('biddapit/subject/update_subject_from', $data);
	}

	public function update_subject()
	{
		$id = $this->input->post('id');
		$user_name = $this->session->userdata("user_name");
		$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));
		$text = $this->input->post('subject_name');
		$slug = $this->make_slug($text);
		$data = array(
			'subject_name' => $text,
			'subject_slug' => $slug,
			'question_limit' => $this->input->post('question_limit'),
			'job' => $this->input->post('job'),
			'five' => $this->input->post('five'),
			'six' => $this->input->post('six'),
			'seven' => $this->input->post('seven'),
			'eight' => $this->input->post('eight'),
			'nine' => $this->input->post('nine'),
			'ten' => $this->input->post('ten'),
			'eleven' => $this->input->post('eleven'),
			'twelve' => $this->input->post('twelve'),
			'created_by' => $user_name,
			'remarks' => 'Update',
			'date_and_time' => $dt->format('F j, Y, g:i a')
		);
		$data1 = array();
		if (!empty($_FILES)) {
			$config['upload_path'] = 'public/subject_images';
			$config['allowed_types'] = 'jpg|png|docx|doc|pdf';
			$config['max_size'] = 100000;
			$config['max_width'] = 100024;
			$config['max_height'] = 100000;
			$config['file_name'] = date('d-m-Y') . '_' . time();
			$this->load->library('upload', $config);
			if (!$this->upload->do_upload('subject_image')) {
				echo $this->upload->display_errors();
			} else {
				$recipe_file = $this->upload->data();
				$file = $recipe_file['file_name'];
				$data1 = array(
					'subject_image' => $file
				);
			}
		}
		$result = array_merge($data, $data1);
		$this->Main_model->updateData($result, "biddapit_subject", "id='$id'");
		if ($result) {
			$msg['load_success_message'] = "Subject update successfully.";
			$this->load->view('messages/success_message', $msg);
		}
	}

	function make_slug($text)
	{
		// ১. সব কিছুকে lowercase করো
		$text = mb_strtolower($text, 'UTF-8');
		// ২. ইংরেজি ছাড়া সব symbol, punctuation, quote, ইত্যাদি replace করো
		// বাংলা ইউনিকোড রেঞ্জ \x{0980}-\x{09FF} রাখছি
		$text = preg_replace('/[^a-z0-9\x{0980}-\x{09FF}]+/u', '-', $text);
		// ৩. শুরু ও শেষে থাকা dash remove করো
		$text = trim($text, '-');
		// ৪. একটার বেশি dash থাকলে একটাতে কমিয়ে দাও
		$text = preg_replace('/-+/', '-', $text);
		return $text;
	}
}

?>
