<?php

class Subject_assigning extends MX_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('biddapit/Subject_assigning_model');
	}

	public function index()
	{

	}

	public function all_subject_assigning()
	{
		$this->config->load('pagination');
		$this->load->library("pagination");
		$config = array();
		$config["base_url"] = base_url() . "biddapit/subject_assigning/all_subject_assigning";
		$config["total_rows"] = $this->Main_model->countAll('biddapit_subject_assigning');;
		$config['per_page'] = 20;
		$config['uri_segment'] = 4;
		$config['num_links'] = 2;
		$this->pagination->initialize($config);
		$page = ($this->uri->segment(4)) ? $this->uri->segment(4) : 0;
		$data["subject_assigning"] = $this->Subject_assigning_model->select_all_subject_assigning($config["per_page"], $page);
		$data["links"] = $this->pagination->create_links();
		if ($this->input->is_ajax_request()) {
			$this->load->view('subject_assigning/per_page_subject_assigning', $data);
		} else {
			$this->load->view('subject_assigning/subject_assigning_tpl', $data);
		}
	}

	public function load_add_subject_assigning_from()
	{
		$data['category'] = $this->Main_model->getValue("", 'biddapit_category', '*', "id desc");
		$data['subject'] = $this->Main_model->getValue("", 'biddapit_subject', '*', "id desc");
		$this->load->view('biddapit/subject_assigning/subject_assigning_from', $data);
	}

	public function create_subject_assigning()
	{
		$user_name = $this->session->userdata("user_name");
		$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));
		$data = array(
			'category_id' => $this->input->post('category_id'),
			'subject_id' => $this->input->post('subject_id'),
			'created_by' => $user_name,
			'remarks' => 'Add',
			'date_and_time' => $dt->format('F j, Y, g:i a')
		);
		$result = $this->Main_model->insertData($data, 'biddapit_subject_assigning');
		if ($result) {
			$msg['load_success_message'] = "Subject assigning successfully added.";
			$this->load->view('messages/success_message', $msg);
		}
	}

	public function load_update_subject_assigning_from($id)
	{
		$data['category'] = $this->Main_model->getValue("", 'biddapit_category', '*', "id desc");
		$data['subject'] = $this->Main_model->getValue("", 'biddapit_subject', '*', "id desc");
		$data['subject_assigning'] = $this->Main_model->getValue("id = '$id'", 'biddapit_subject_assigning', '*', "id desc");
		$this->load->view('biddapit/subject_assigning/update_subject_assigning_from', $data);
	}

	public function update_subject_assigning()
	{
		$id = $this->input->post('id');
		$user_name = $this->session->userdata("user_name");
		$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));
		$data = array(
			'category_id' => $this->input->post('category_id'),
			'subject_id' => $this->input->post('subject_id'),
			'created_by' => $user_name,
			'remarks' => 'Update',
			'date_and_time' => $dt->format('F j, Y, g:i a')
		);
		$result = $this->Main_model->updateData($data, "biddapit_subject_assigning", "id='$id'");
		if ($result) {
			$msg['load_success_message'] = "Subject assigning update successfully.";
			$this->load->view('messages/success_message', $msg);
		}
	}
}

?>
