<?php

class Subject_child extends MX_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('biddapit/Subject_child_model');
	}

	public function index()
	{

	}

	public function all_subject_child()
	{
		$this->config->load('pagination');
		$this->load->library("pagination");
		$config = array();
		$config["base_url"] = base_url() . "biddapit/subject_child/all_subject_child";
		$config["total_rows"] = $this->Main_model->countAll('biddapit_subject_child');;
		$config['per_page'] = 20;
		$config['uri_segment'] = 4;
		$config['num_links'] = 2;
		$this->pagination->initialize($config);
		$page = ($this->uri->segment(4)) ? $this->uri->segment(4) : 0;
		$data["subject_child"] = $this->Subject_child_model->select_all_subject_child($config["per_page"], $page);
		$data["links"] = $this->pagination->create_links();
		if ($this->input->is_ajax_request()) {
			$this->load->view('subject_child/per_page_subject_child', $data);
		} else {
			$this->load->view('subject_child/subject_child_tpl', $data);
		}
	}

	public function load_add_subject_child_from()
	{
		$data['subject'] = $this->Main_model->getValue("", 'biddapit_subject', '*', "id desc");
		$this->load->view('biddapit/subject_child/subject_child_from', $data);
	}

	public function create_subject_child()
	{
		$user_name = $this->session->userdata("user_name");
		$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));
		$text = $this->input->post('subject_child_name');
		$slug = $this->make_slug($text);
		$subject_id = $this->input->post('subject_id');
		$result = explode(",", $subject_id);
		$data = array(
			'subject_child_name' => $text,
			'subject_child_slug' => $slug,
			'subject_id' => $result[0],
			'subject_slug' => $result[1],
			'merge_slug' => $slug . "-" . $result[1],
			'job' => $this->input->post('job'),
			'five' => $this->input->post('five'),
			'six' => $this->input->post('six'),
			'seven' => $this->input->post('seven'),
			'eight' => $this->input->post('eight'),
			'nine' => $this->input->post('nine'),
			'ten' => $this->input->post('ten'),
			'eleven' => $this->input->post('eleven'),
			'twelve' => $this->input->post('twelve'),
			'created_by' => $user_name,
			'remarks' => 'Add',
			'date_and_time' => $dt->format('F j, Y, g:i a')
		);
		$data1 = array();
		if (!empty($_FILES)) {
			$config['upload_path'] = 'public/subject_images';
			$config['allowed_types'] = 'jpg|png|docx|doc|pdf';
			$config['max_size'] = 100000;
			$config['max_width'] = 100024;
			$config['max_height'] = 100000;
			$config['file_name'] = date('d-m-Y') . '_' . time();
			$this->load->library('upload', $config);
			if (!$this->upload->do_upload('child_image')) {
				echo $this->upload->display_errors();
			} else {
				$recipe_file = $this->upload->data();
				$file = $recipe_file['file_name'];
				$data1 = array(
					'child_image' => $file
				);
			}
		}
		$result = array_merge($data, $data1);
		$this->Main_model->insertData($result, 'biddapit_subject_child');
		if ($result) {
			$msg['load_success_message'] = "Subject child successfully added.";
			$this->load->view('messages/success_message', $msg);
		}
	}

	public function load_update_subject_child_from($id)
	{
		$data['subject_child'] = $this->Main_model->getValue("id = '$id'", 'biddapit_subject_child', '*', "id desc");
		$this->load->view('biddapit/subject_child/update_subject_child_from', $data);
	}

	public function update_subject_child()
	{
		$id = $this->input->post('id');
		$user_name = $this->session->userdata("user_name");
		$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));
		$text = $this->input->post('subject_child_name');
		$slug = $this->make_slug($text);
		$subject_id = $this->input->post('subject_id');
		$result = explode(",", $subject_id);
		$data = array(
			'subject_child_name' => $text,
			'subject_child_slug' => $slug,
			'subject_id' => $result[0],
			'subject_slug' => $result[1],
			'merge_slug' => $slug . "-" . $result[1],
			'job' => $this->input->post('job'),
			'five' => $this->input->post('five'),
			'six' => $this->input->post('six'),
			'seven' => $this->input->post('seven'),
			'eight' => $this->input->post('eight'),
			'nine' => $this->input->post('nine'),
			'ten' => $this->input->post('ten'),
			'eleven' => $this->input->post('eleven'),
			'twelve' => $this->input->post('twelve'),
			'created_by' => $user_name,
			'remarks' => 'Update',
			'date_and_time' => $dt->format('F j, Y, g:i a')
		);
		$data1 = array();
		if (!empty($_FILES)) {
			$config['upload_path'] = 'public/subject_images';
			$config['allowed_types'] = 'jpg|png|docx|doc|pdf';
			$config['max_size'] = 100000;
			$config['max_width'] = 100024;
			$config['max_height'] = 100000;
			$config['file_name'] = date('d-m-Y') . '_' . time();
			$this->load->library('upload', $config);
			if (!$this->upload->do_upload('child_image')) {
				echo $this->upload->display_errors();
			} else {
				$recipe_file = $this->upload->data();
				$file = $recipe_file['file_name'];
				$data1 = array(
					'child_image' => $file
				);
			}
		}
		$result = array_merge($data, $data1);
		$this->Main_model->updateData($result, "biddapit_subject_child", "id='$id'");
		if ($result) {
			$msg['load_success_message'] = "Subject child update successfully.";
			$this->load->view('messages/success_message', $msg);
		}
	}

	function make_slug($text)
	{
		// ১. সব কিছুকে lowercase করো
		$text = mb_strtolower($text, 'UTF-8');
		// ২. ইংরেজি ছাড়া সব symbol, punctuation, quote, ইত্যাদি replace করো
		// বাংলা ইউনিকোড রেঞ্জ \x{0980}-\x{09FF} রাখছি
		$text = preg_replace('/[^a-z0-9\x{0980}-\x{09FF}]+/u', '-', $text);
		// ৩. শুরু ও শেষে থাকা dash remove করো
		$text = trim($text, '-');
		// ৪. একটার বেশি dash থাকলে একটাতে কমিয়ে দাও
		$text = preg_replace('/-+/', '-', $text);
		return $text;
	}
}

?>
