<?php

class Subscription extends MX_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('biddapit/Subscription_model');
	}

	public function index()
	{

	}

	public function all_subscription()
	{
		$this->config->load('pagination');
		$this->load->library("pagination");
		$config = array();

		$subscription_name = $this->input->post('subscription_name');
		$amount = $this->input->post('amount');

		$config["base_url"] = base_url() . "biddapit/subscription/all_subscription";
		if ($subscription_name) {
			$result = $this->Subscription_model->count_by_search_subscription('$subscription_name');
			$config["total_rows"] = count($result);
		}else if($amount){
			$result = $this->Subscription_model->count_by_search_subscription_amount('$amount');
			$config["total_rows"] = count($result);
		} else {
			$config["total_rows"] = $this->Main_model->countAll('biddapit_subscription_plan');
		}
		$config['per_page'] = 20;
		$config['uri_segment'] = 4;
		$config['num_links'] = 9;
		$this->pagination->initialize($config);
		$page = ($this->uri->segment(4)) ? $this->uri->segment(4) : 0;

		if ($subscription_name) {
			$data["menu"] = $this->Subscription_model->select_all_subscription_by_search($config["per_page"], $page,$subscription_name);
		}else if($amount){
			$data["menu"] = $this->Subscription_model->select_all_subscription_by_search_amount($config["per_page"], $page,$amount);
		} else {
			$data["menu"] = $this->Subscription_model->select_all_subscription($config["per_page"], $page);
		}
		$data["links"] = $this->pagination->create_links();
		if ($this->input->is_ajax_request()) {
			$this->load->view('subscription/per_page_subscription', $data);
		} else {
			$this->load->view('subscription/subscription_tpl', $data);
		}
	}

	public function load_add_subscription_from()
	{
		$this->load->view('biddapit/subscription/subscription_from');
	}

	public function create_subscription()
	{
		$user_name = $this->session->userdata("user_name");
		$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));
		$data = array(
			'amount' => $this->input->post('amount'),
			'discount' => $this->input->post('discount'),
			'duration' => $this->input->post('duration'),
			'name' => $this->input->post('name'),
			'description' => $this->input->post('description'),
			'created_by' => $user_name,
			'remarks' => 'Add',
			'date_and_time' => $dt->format('F j, Y, g:i a')
		);
		$result = $this->Main_model->insertData($data, 'biddapit_subscription_plan');
		if ($result) {
			$msg['load_success_message'] = "Subscription successfully added.";
			$this->load->view('messages/success_message', $msg);
		}
	}


	public function load_update_subscription_from()
	{
		$id = $this->input->post('id');
		$data['subscription'] = $this->Main_model->getValue("id = '$id'", 'biddapit_subscription_plan', '*', "ID DESC");
		$this->load->view('biddapit/subscription/update_subscription_from', $data);
	}


	public function update_subscription()
	{

		$user_name = $this->session->userdata("user_name");
		$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));
		$id = $this->input->post('id');
		$data = array(
			'amount' => $this->input->post('amount'),
			'discount' => $this->input->post('discount'),
			'duration' => $this->input->post('duration'),
			'name' => $this->input->post('name'),
			'description' => $this->input->post('description'),
			'created_by' => $user_name,
			'remarks' => 'Update',
			'date_and_time' => $dt->format('F j, Y, g:i a')
		);
		$result = $this->Main_model->updateData($data, "biddapit_subscription_plan", "id='$id'");
		if ($result) {
			$msg['load_success_message'] = "Subscription update successfully.";
			$this->load->view('messages/success_message', $msg);
		}
	}
}

?>
