<?php

class Teacher extends MX_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('biddapit/Teacher_model');
	}

	public function index()
	{

	}

	public function all_teacher()
	{
		$this->config->load('pagination');
		$this->load->library("pagination");
		$config = array();

		$teacher_name = $this->input->post('teacher_name');
		$designation = $this->input->post('designation');

		$config["base_url"] = base_url() . "biddapit/teacher/all_teacher";
		if ($teacher_name) {
			$result = $this->Teacher_model->count_by_teacher_search($teacher_name);
			$config["total_rows"] = count($result);
		}else if($designation){
			$result = $this->Teacher_model->count_by_teacher_designation($designation);
			$config["total_rows"] = count($result);
		} else {
			$config["total_rows"] = $this->Main_model->countAll('biddapit_teacher');
		}
		$config['per_page'] = 30;
		$config['uri_segment'] = 4;
		$config['num_links'] = 9;
		$this->pagination->initialize($config);
		$page = ($this->uri->segment(4)) ? $this->uri->segment(4) : 0;

		if($teacher_name){
			$data["teacher"] = $this->Teacher_model->select_all_teacher_by_search($config["per_page"], $page,$teacher_name);
		}else if($designation){
			$data["teacher"] = $this->Teacher_model->select_all_teacher_by_designation($config["per_page"], $page,$designation);
		}else{
			$data["teacher"] = $this->Teacher_model->select_all_teacher($config["per_page"], $page);
		}

		$data["links"] = $this->pagination->create_links();
		if ($this->input->is_ajax_request()) {
			$this->load->view('teacher/per_page_teacher', $data);
		} else {
			$this->load->view('teacher/teacher_tpl', $data);
		}
	}

	public function load_add_teacher_from()
	{
		$this->load->view('biddapit/teacher/teacher_from');
	}

	public function create_teacher()
	{
		$user_name = $this->session->userdata("user_name");
		$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));
		$data = array(
			'teacher_name' => $this->input->post('teacher_name'),
			'picture' => $this->input->post('picture'),
			'designation' => $this->input->post('designation'),
			'created_by' => $user_name,
			'remarks' => 'Add',
			'date_and_time' => $dt->format('F j, Y, g:i a')
		);
		$result = $this->Main_model->insertData($data, 'biddapit_teacher');
		if ($result) {
			$msg['load_success_message'] = "Teacher successfully added.";
			$this->load->view('messages/success_message', $msg);
		}
	}


	public function load_update_teacher_from()
	{
		$id = $this->input->post('id');
		$data['teacher'] = $this->Main_model->getValue("id = '$id'", 'biddapit_teacher', '*', "ID DESC");
		$this->load->view('biddapit/teacher/update_teacher_from', $data);
	}

	public function update_teacher()
	{
		$user_name = $this->session->userdata("user_name");
		$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));
		$id = $this->input->post('id');
		$data = array(
			'teacher_name' => $this->input->post('teacher_name'),
			'picture' => $this->input->post('picture'),
			'designation' => $this->input->post('designation'),
			'created_by' => $user_name,
			'remarks' => 'Update',
			'date_and_time' => $dt->format('F j, Y, g:i a')
		);
		$result = $this->Main_model->updateData($data, "biddapit_teacher", "id='$id'");
		if ($result) {
			$msg['load_success_message'] = "Teacher update successfully.";
			$this->load->view('messages/success_message', $msg);
		}
	}
}

?>
