<?php

class Model_question_add_model extends CI_Model
{
	public function select_all_question($limit, $start, $subject_id = null, $child_id = null, $sub_child_id = null)
	{
		$this->db->limit($limit, $start);
		$this->db->select('biddapit_question.*,biddapit_subject.subject_name,biddapit_subject_child.subject_child_name,biddapit_subject_sub_child.subject_sub_child_name');
		if ($subject_id) {
			$this->db->where('biddapit_question.subject_id', $subject_id);
		}
		if ($child_id) {
			$this->db->where('biddapit_question.subject_child_id', $child_id);
		}
		if ($sub_child_id) {
			$this->db->where('biddapit_question.subject_sub_child_id', $sub_child_id);
		}
		$this->db->join('biddapit_subject', 'biddapit_subject.id = biddapit_question.subject_id');
		$this->db->join('biddapit_subject_child', 'biddapit_subject_child.id = biddapit_question.subject_child_id');
		$this->db->join('biddapit_subject_sub_child', 'biddapit_subject_sub_child.id = biddapit_question.subject_sub_child_id');
		$this->db->order_by('id', "desc");
		$query_result = $this->db->get('biddapit_question');
		$result = $query_result->result();
		return $result;
	}


	public function countAllByCondition($subject_id = null, $child_id = null, $sub_child_id = null)
	{
		$this->db->select('id');
		if ($subject_id) {
			$this->db->where('subject_id', $subject_id);
		}
		if ($child_id) {
			$this->db->where('subject_child_id', $child_id);
		}
		if ($sub_child_id) {
			$this->db->where('subject_sub_child_id', $sub_child_id);
		}
		$this->db->order_by('id', "desc");
		$query_result = $this->db->get('biddapit_question');
		$result = $query_result->result();
		return $result;
	}

	public function select_syllabus_by_category($model_test_id)
	{
		$this->db->select('biddapit_subject.subject_name,biddapit_model_test_syllabus.*');
		$this->db->where('biddapit_model_test.id', $model_test_id);
		$this->db->join('biddapit_model_test_syllabus', 'biddapit_model_test_syllabus.category_id = biddapit_model_test.category_id');
		$this->db->join('biddapit_subject', 'biddapit_subject.id = biddapit_model_test_syllabus.subject_id');
		$this->db->where('biddapit_model_test_syllabus.type', 1);
		$this->db->order_by('biddapit_subject.id', "desc");
		$query_result = $this->db->get('biddapit_model_test');
		$result = $query_result->result();
		return $result;
	}

	public function count_all_question($model_test_id, $subject_id)
	{
		$this->db->select('count(id) total');
		$this->db->where('model_test_id', $model_test_id);
		$this->db->where('subject_id', $subject_id);
		$query_result = $this->db->get('biddapit_model_test_child');
		$result = $query_result->row();
		return $result;
	}

	public function select_syllabus_question($subject_id, $model_test_id)
	{
		$this->db->select('biddapit_model_test_syllabus.total_question');
		$this->db->where('biddapit_model_test.id', $model_test_id);
		$this->db->join('biddapit_model_test_syllabus', 'biddapit_model_test_syllabus.category_id = biddapit_model_test.category_id');
		$this->db->where('biddapit_model_test_syllabus.subject_id', $subject_id);
		$query_result = $this->db->get('biddapit_model_test');
		$result = $query_result->row();
		return $result;
	}

	public function select_all_previous_question($model_test_id)
	{
		$this->db->select('biddapit_prev_year_question.question_id,biddapit_question.subject_id');
		$this->db->where('biddapit_prev_year_question.previous_id', $model_test_id);
		$this->db->join('biddapit_question', 'biddapit_question.id = biddapit_prev_year_question.question_id');
		$query_result = $this->db->get('biddapit_prev_year_question');
		$result = $query_result->result();
		return $result;
	}

	public function select_model_test_name()
	{
		$q = $this->db->select('mt.id, mt.model_test_name')
			->from('biddapit_model_test AS mt')
			->join('biddapit_model_test_child AS mc', 'mc.model_test_id = mt.id', 'left')
			->where('mc.model_test_id IS NULL', null, false) // raw where
			->get();
		return $result = $q->result();
	}

	public function pick_random_questions_locked($limit, $subject_id)
	{
		$limit = (int)$limit;
		if ($limit <= 0) return [];
		$this->db->trans_start();

		// 1) লকসহ আইডি তুলি (লকড রো স্কিপ করবে)
		$sql = "SELECT id FROM biddapit_question WHERE subject_id = ? AND in_use = 0 ORDER BY RAND() LIMIT {$limit} FOR UPDATE SKIP LOCKED";
		$ids = $this->db->query($sql, [$subject_id])->result_array();
		if (empty($ids)) {
			$this->db->trans_complete();
			return [];
		}
		$picked_ids = array_column($ids, 'id');
		// 2) সাথে সাথে রিজার্ভ/লক মার্কার সেট
		$this->db->where_in('id', $picked_ids)
			->set('in_use', 1)
			->set('locked_at', 'CURRENT_TIMESTAMP', false) // ey line ta kano use korbo
			->update('biddapit_question');

		// 3) একই অর্ডার রেখে ফাইনাল ডেটা ফেরত
		$id_list = implode(',', array_map('intval', $picked_ids));
		$res = $this->db->query("SELECT id AS question_id FROM biddapit_question WHERE id IN ($id_list) ORDER BY FIELD(id, $id_list)")->result();

		$this->db->trans_complete();
		// ট্রানজ্যাকশন ফেল হলে খালি অ্যারে
		if ($this->db->trans_status() === false) return [];

		return $res;
	}


}
