<?php

class Sub_category_model extends CI_Model
{

	public function select_all_sub_category($limit, $start)
	{
		$this->db->limit($limit, $start);
		$this->db->select('biddapit_sub_category.*,biddapit_category.category_name');
		$this->db->join('biddapit_category', 'biddapit_category.id = biddapit_sub_category.category_id');
		$this->db->order_by('biddapit_sub_category.id', "desc");
		$query_result = $this->db->get('biddapit_sub_category');
		$result = $query_result->result();
		return $result;
	}

	public function select_all_Bank_branch_by_name($limit, $start, $bank_branch_name)
	{
		$this->db->limit($limit, $start);
		$this->db->select('biddapit_sub_category.*,biddapit_category.category_name');
		$this->db->like('biddapit_sub_category.Bank_branch_name', $bank_branch_name, 'after');
		$this->db->join('biddapit_category', 'biddapit_category.id = biddapit_sub_category.category_id', 'LEFT');
		$this->db->order_by('id', "DESC");
		$query_result = $this->db->get('biddapit_sub_category');
		$result = $query_result->result();
		return $result;
	}

	public function select_all_Bank_branch_by_category_id($limit, $start, $category_id)
	{
		$this->db->limit($limit, $start);
		$this->db->select('biddapit_sub_category.*,biddapit_category.category_name');
		$this->db->where('biddapit_sub_category.category_id', $category_id);
		$this->db->join('biddapit_category', 'biddapit_category.id = biddapit_sub_category.category_id', 'LEFT');
		$this->db->order_by('id', "DESC");
		$query_result = $this->db->get('biddapit_sub_category');
		$result = $query_result->result();
		return $result;
	}

	public function check_duplicate_data($bank_branch_name, $category_id)
	{
		$this->db->select('*');
		$this->db->where('sub_category_name', $bank_branch_name);
		$this->db->where('category_id', $category_id);
		$query_result = $this->db->get('biddapit_sub_category');
		$result = $query_result->result();
		return $result;
	}

}
