<?php
function renderMixedMathInline(string $s): string
{
	$s = preg_replace('/\s+/u', ' ', $s);
	$parts = preg_split('/([\x{0980}-\x{09FF}][\x{0980}-\x{09FF}\s\.\,\;\:\!\?]*)/u',
			$s, -1, PREG_SPLIT_DELIM_CAPTURE);
	$out = '';
	foreach ($parts as $idx => $p) {
		if ($p === '') continue;
		if ($idx % 2 === 1) {
			$out .= htmlspecialchars(trim($p), ENT_QUOTES | ENT_HTML5, 'UTF-8') . ' ';
		} else {
			$m = trim($p);
			if ($m !== '') $out .= '\\(' . $m . '\\)' . ' ';
		}
	}
	return trim($out);
}

?>

<style>
	.table td, .table th {
		padding: 6px;
	}
</style>

<script id="MathJax-script" async
		src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js">
</script>

<?php
$primary_color_code = $this->session->userdata('primary_color_code');
?>
<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="card-header">
				<div class="row">
					<div class="col-lg-12">
						<div class="pageheader" style="background-color: #F5F5F5;">
							<h4>Question Information Page <br></h4>
							<ol class="breadcrumb" style="background-color: #F5F5F5;">
								<li><a href="<?php echo base_url() ?>hr/resume/all_resume">Dashboard</a></li>
								<li class="active" style="padding-left: 10px;">Add edit delete view.....</li>
							</ol>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!-- Main content -->
	<section class="content">
		<div class="container-fluid">
			<div class="row">
				<div class="col-md-12">
					<div class="card">
						<div class="card-header">
							<div class="row">
								<div class="col-md-3">
									<select name="status" id="status" class="form-control">
										<option value="">Select One</option>
										<option value="0">general</option>
										<option value="1">উদ্দীপক</option>
										<option value="2">Math Question</option>
									</select>
								</div>
							</div>
						</div>
						<!-- /.card-header -->
						<div class="card-body">
							<div id="ajaxdata">
								<?php echo $links; ?>
								<table class="table table-striped table-bordered table-hover">
									<thead style="background-color: <?php echo $primary_color_code; ?>">
									<tr>
										<td>Sl No.</td>
										<td>Question & Option</td>
										<td style="width: 250px;">Subject & Correct Answer</td>
										<td>Solve Note</td>
										<td>Previous year question</td>
										<td>Action</td>
									</tr>
									</thead>
									<tbody>
									<?php
									$i = 0;
									foreach ($question as $v_data) {
										$i++; ?>
										<tr>
											<td><?php echo $i; ?></td>
											<td>
												<div>
													<?php if ($v_data->question_status == 2) { ?>
														<img style="height: 100px; width: 100px;"
															 src="<?php echo base_url() ?>public/question_image/<?php echo $v_data->question; ?>">
													<?php } else { ?>
														<?php if ($v_data->status == 1) { ?>
															উদ্দীপক :<?php echo $v_data->question; ?>
														<?php } else { ?>
															<?= renderMixedMathInline($v_data->question) ?>
														<?php } ?>
													<?php } ?>
												</div>

												<?php if ($v_data->question_slug) { ?>

												<?php } else {
													$taglessBody = strip_tags($v_data->question);
													$newtitle = preg_replace('/\s+/', '-', $taglessBody);
													$question1 = html_entity_decode($newtitle, ENT_QUOTES, "UTF-8");
													?>
													<input value="<?php echo $question1; ?>"
														   id="question<?php echo $v_data->id; ?>" type="hidden">
													<div>
														<?php if ($v_data->question_status == 1) { ?>
															<input type="button"
																   onclick="add_slug(<?php echo $v_data->id ?>)"
																   value="Add Slug"
																   class="btn btn-outline-success">
														<?php } else { ?>
															<a style="font-size: 10px;" href="#"
															   onclick="add_slug_for_image_question(<?php echo $v_data->id; ?>)"
															   class="btn btn-outline-success" data-backdrop="static"
															   data-keyboard="false" data-toggle="modal"
															   data-target="#load_modal_lg"
															   title="Update question">
																Add Slug
															</a>
														<?php } ?>
													</div>
													<div id="lsug_msg<?php echo $v_data->id; ?>"></div>
												<?php } ?>

												<?php if ($v_data->status == 1) { ?>
													<?php
													$stimulant_question = $this->Main_model->getValue("question_id = '$v_data->id'", 'biddapit_question_stimulant', '*', "id asc");
													foreach ($stimulant_question as $v_stimulant) { ?>
														<div>প্রশ্ন:
															<?php if ($v_stimulant->question_status == 1) { ?>
																<?php echo $v_stimulant->question; ?>
															<?php } else { ?>
																<img style="height: 100px; width: 100px;"
																	 src="<?php echo base_url() ?>public/question_image/<?php echo $v_stimulant->question; ?>">
															<?php } ?>

															<input type="hidden"
																   id="question_id1<?php echo $v_data->id . $v_stimulant->id; ?>"
																   value="<?php echo $v_data->id; ?>">
															<input type="hidden"
																   id="stimulant_question_id1<?php echo $v_data->id . $v_stimulant->id; ?>"
																   value="<?php echo $v_stimulant->id; ?>">
															<a style="font-size: 10px;" href="#"
															   onclick="edit_uddipak_question(<?php echo $v_data->id . $v_stimulant->id; ?>)"
															   class="btn btn-outline-success" data-backdrop="static"
															   data-keyboard="false" data-toggle="modal"
															   data-target="#load_modal_xl"
															   title="Update question">
																<i class="fa fa-edit"></i>
															</a>
														</div>
														<div class="mt-2">
															<div style="color: green;">
																A. <?php echo $v_stimulant->option_one; ?></div>
															<div style="color: #22298bc9;">
																B. <?php echo $v_stimulant->option_two; ?></div>
															<div style="color: #730df5;">
																C. <?php echo $v_stimulant->option_three; ?></div>
															<div style="color: #161503;">
																D. <?php echo $v_stimulant->option_four; ?></div>
															<div style="color: #022095;">
																E. <?php echo $v_stimulant->option_five; ?></div>
															<div style="color: green;">
																F. <?php echo $v_stimulant->option_six; ?></div>
														</div>
														<div style="background-color: #f59001; width: 33px; border-radius: 16px; height: 33px; color: white; text-align: center; font-size: 20px;">
															<?php echo $v_stimulant->answer; ?>
														</div>
													<?php } ?>
												<?php } else { ?>
													<div style="color: green;">
														A. <?php echo $v_data->option_one; ?></div>
													<div style="color: #22298bc9;">
														B. <?php echo $v_data->option_two; ?></div>
													<div style="color: #730df5;">
														C. <?php echo $v_data->option_three; ?></div>
													<div style="color: #161503;">
														D. <?php echo $v_data->option_four; ?></div>
													<div style="color: #022095;">
														E. <?php echo $v_data->option_five; ?></div>
													<div style="color: green;">
														F. <?php echo $v_data->option_six; ?></div>
												<?php } ?>
											</td>

											<td>
												<div style="color: green;">
													Subject:<?php echo $v_data->subject_name; ?></div>
												<div style="color: #a915d7;">Subject
													Child:<?php echo $v_data->subject_child_name; ?></div>
												<div style="color: #ff040d;">Sub
													Child:<?php echo $v_data->subject_sub_child_name; ?></div>
												<div style="background-color: #f59001; width: 33px; border-radius: 16px; height: 33px; color: white; text-align: center; font-size: 20px;">
													<?php echo $v_data->answer; ?>
												</div>
											</td>

											<td>
												<?php if ($v_data->status == 1) { ?>
													<?php foreach ($stimulant_question as $v_answer) { ?>
														<div class="mt-2">
															প্রশ্ন:
															<?php if ($v_answer->question_status == 1) { ?>
																<?php echo $v_answer->question; ?>
															<?php } else { ?>
																<img style="height: 100px; width: 100px;"
																	 src="<?php echo base_url() ?>public/question_image/<?php echo $v_answer->question; ?>">
															<?php } ?>
															<input type="hidden"
																   id="question_id<?php echo $v_data->id . $v_answer->id; ?>"
																   value="<?php echo $v_data->id; ?>">
															<input type="hidden"
																   id="stimulant_question_id<?php echo $v_data->id . $v_answer->id; ?>"
																   value="<?php echo $v_answer->id; ?>">
															<a style="font-size: 10px;" href="#"
															   onclick="edit_uddipak_question_answer(<?php echo $v_data->id . $v_answer->id; ?>)"
															   class="btn btn-outline-success" data-backdrop="static"
															   data-keyboard="false" data-toggle="modal"
															   data-target="#load_modal_lg"
															   title="Update question">
																<i class="fa fa-edit"></i>
															</a>
														</div>
														<div class="mt-2">
															সমাধান :
															<?php if ($v_answer->answer_description == 1) {
																$multiline1 = $this->Main_model->getValue("question_id = '$v_data->id' and stimulant_question_id ='$v_answer->id'", 'biddapit_question_ans_multi_line', '*', "id asc");
																foreach ($multiline1 as $v_multiline1) { ?>
																	<div>
																		<?php echo $v_multiline1->description; ?>
																	</div>
																<?php } ?>
															<?php } else { ?>
																<?php echo $v_answer->answer_description; ?>
															<?php } ?>
														</div>
													<?php } ?>
												<?php } else { ?>
													<div style="margin-top: 5px;">
														<?php if ($v_data->answer_description == 1) {
															$multiline = $this->Main_model->getValue("question_id = '$v_data->id'", 'biddapit_question_ans_multi_line', '*', "id asc");
															foreach ($multiline as $v_multiline) {
																?>
																<div><?php echo $v_multiline->description; ?></div>
															<?php } ?>
														<?php } else {
															echo $v_data->answer_description;
														} ?>
													</div>
												<?php } ?>
											</td>

											<td style="width: 360px;">
												<?php
												$get_result = $this->Question_model->select_previous_year_question($v_data->id);
												foreach ($get_result as $v_result) {
													?>
													<div><?php echo $v_result->description; ?></div>
												<?php } ?>
											</td>
											<td style="width: 120px;">
												<div>
													<a style="font-size: 10px; width: 101px" href="#"
													   onclick="previous_year_question(<?php echo $v_data->id; ?>)"
													   class="btn btn-outline-warning" data-backdrop="static"
													   data-keyboard="false" data-toggle="modal"
													   data-target="#load_modal_lg"
													   title="Update question">
														বিগত বছরের প্রশ্ন
													</a>
												</div>
												<?php if ($v_data->status == 1) { ?>
													<div style="margin-top: 5px;">
														<a style="font-size: 10px; width: 101px;" href="#"
														   onclick="answer_description_uddipok(<?php echo $v_data->id; ?>)"
														   class="btn btn-outline-danger" data-backdrop="static"
														   data-keyboard="false" data-toggle="modal"
														   data-target="#load_modal_lg"
														   title="Update question">
															প্রশ্নের উত্তর
														</a>
													</div>
												<?php } else { ?>
													<div style="margin-top: 5px;">
														<a style="font-size: 10px; width: 101px;" href="#"
														   onclick="answer_description(<?php echo $v_data->id; ?>)"
														   class="btn btn-outline-danger" data-backdrop="static"
														   data-keyboard="false" data-toggle="modal"
														   data-target="#load_modal_lg"
														   title="Update question">
															প্রশ্নের উত্তর
														</a>
													</div>
												<?php } ?>
												<div style="margin-top: 10px;">
													<a style="font-size: 10px;" href="#"
													   onclick="update_question(<?php echo $v_data->id; ?>)"
													   class="btn btn-outline-success" data-backdrop="static"
													   data-keyboard="false" data-toggle="modal"
													   data-target="#load_modal_xl"
													   title="Update question">
														<i class="fas fa-edit"></i>
													</a>
													<?php if ($v_data->status == 1) { ?>
														<a style="font-size: 10px;" href="#"
														   onclick="uddipok_question(<?php echo $v_data->id; ?>)"
														   class="btn btn-outline-info" data-backdrop="static"
														   data-keyboard="false" data-toggle="modal"
														   data-target="#load_modal_xl"
														   title="Update question">
															উদ্দীপক
														</a>
													<?php } ?>
												</div>
											</td>
										</tr>
									<?php } ?>
									</tbody>
								</table>
								<?php echo $links; ?>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
</div>

<script>
	function add_slug($id) {
		const id = $id;
		const question = $('#question' + id + "").val();
		$.ajax({
			type: "POST",
			url: '<?php echo base_url() ?>biddapit/question/add_slug',
			data: {id: id, question: question},
			success: function (result) {
				if (result) {
					$('#lsug_msg' + id + "").html(result);
					return false;
				} else {
					return false;
				}
			}
		});
		return false;
	}
</script>

<script>
	function previous_year_question($id) {
		const id = $id;
		const question = $('#question' + id + "").val();
		$.ajax({
			type: "POST",
			url: '<?php echo base_url() ?>biddapit/question/previous_year_question_from',
			data: {id: id, question: question},
			success: function (result) {
				if (result) {
					$('#load_from_lg').html(result);
					$('#title_lg').html("বিগত বছরের প্রশ্ন");
				} else {
					return false;
				}
			}
		});
		return false;
	}
</script>


<script>
	function update_question($id) {
		const id = $id;
		$.ajax({
			type: "POST",
			url: '<?php echo base_url() ?>biddapit/question/load_update_question_from',
			data: {id: id},
			success: function (result) {
				if (result) {
					$('#load_from_xl').html(result);
					$('#title_xl').html("Update Question");
					return false;
				} else {
					return false;
				}
			}
		});
		return false;
	}
</script>

<script>
	function uddipok_question($id) {
		const id = $id;
		$.ajax({
			type: "POST",
			url: '<?php echo base_url() ?>biddapit/question/load_uddipok_question_from',
			data: {id: id},
			success: function (result) {
				if (result) {
					$('#load_from_xl').html(result);
					$('#title_xl').html("উদ্দীপক");
					return false;
				} else {
					return false;
				}
			}
		});
		return false;
	}
</script>

<script>
	function answer_description($id) {
		const id = $id;
		$.ajax({
			type: "POST",
			url: '<?php echo base_url() ?>biddapit/question/load_answer_description_from',
			data: {id: id},
			success: function (result) {
				if (result) {
					$('#load_from_lg').html(result);
					$('#title_lg').html("Answer Description");
					return false;
				} else {
					return false;
				}
			}
		});
		return false;
	}
</script>

<script>
	function answer_description_uddipok($id) {
		const id = $id;
		$.ajax({
			type: "POST",
			url: '<?php echo base_url() ?>biddapit/question/load_answer_description_uddipok_from',
			data: {id: id},
			success: function (result) {
				if (result) {
					$('#load_from_lg').html(result);
					$('#title_lg').html("Answer Description");
					return false;
				} else {
					return false;
				}
			}
		});
		return false;
	}
</script>

<script>
	function edit_uddipak_question_answer($id) {
		const id = $id;
		const stimulant_question_id = $('#stimulant_question_id' + id + "").val();
		const question_id = $('#question_id' + id + "").val();
		$.ajax({
			type: "POST",
			url: '<?php echo base_url() ?>biddapit/question/edit_uddipak_question_answer_from',
			data: {stimulant_question_id: stimulant_question_id, question_id: question_id},
			success: function (result) {
				if (result) {
					$('#load_from_lg').html(result);
					$('#title_lg').html("Answer Description");
					return false;
				} else {
					return false;
				}
			}
		});
		return false;
	}
</script>

<script>
	function edit_uddipak_question($id) {
		const id = $id;
		const stimulant_question_id = $('#stimulant_question_id1' + id + "").val();
		const question_id = $('#question_id1' + id + "").val();
		$.ajax({
			type: "POST",
			url: '<?php echo base_url() ?>biddapit/question/edit_uddipak_question_from',
			data: {stimulant_question_id: stimulant_question_id, question_id: question_id},
			success: function (result) {
				if (result) {
					$('#load_from_xl').html(result);
					$('#title_xl').html("Answer Description");
					return false;
				} else {
					return false;
				}
			}
		});
		return false;
	}
</script>

<script>
	function add_slug_for_image_question($id) {
		const id = $id;
		$.ajax({
			type: "POST",
			url: '<?php echo base_url() ?>biddapit/question/load_slug_for_image_question_from',
			data: {id: id},
			success: function (result) {
				if (result) {
					$('#load_from_lg').html(result);
					$('#title_lg').html("Add question slug");
					return false;
				} else {
					return false;
				}
			}
		});
		return false;
	}
</script>

<script>
	$(document).ready(function () {
		$("#ajax_pagingsearc a").attr('onclick', 'return main_page_pagination($(this));');
	});
</script>

<script>
	function main_page_pagination($this) {
		var url = $this.attr("href");
		if (url != '') {
			$.ajax({
				type: "POST",
				url: url,
				success: function (msg) {
					$("#ajaxdata").html(msg);
				}
			});
		}
		return false;
	}
</script>

