<?php

class Main_model extends CI_Model
{

	public function __construct()
	{
		parent::__construct();
	}


	public function select_user_module_id($user_id)
	{
		$this->db->select('module_id');
		$this->db->where('user_id', $user_id);
		$this->db->order_by('id', 'desc');
		$query_result = $this->db->get('user_role_permission');
		$result = $query_result->row();
		return $result;
	}

	public function select_all_module($user_id, $module_id = null)
	{
		$this->db->select('master_module.*');
		$this->db->where('master_module.status', 1);
		if ($module_id) {
			$this->db->where('master_module.id', $module_id);
		}
		$this->db->where('user_role_permission.user_id', $user_id);
		$this->db->where('user_role_permission.module_id = master_module.id');
		$this->db->order_by('master_module.sort', "ASC");
		$this->db->group_by('user_role_permission.module_id');
		$query_result = $this->db->get('master_module,user_role_permission');
		$result = $query_result->result();
		return $result;
	}

	public function select_menu_by_module_id1($id, $user_id)
	{
		$this->db->select('master_menu.*');
		$this->db->where('user_role_permission.user_id', $user_id);
		$this->db->where('user_role_permission.menu_id = master_menu.id');
		$this->db->where('master_menu.module_id', $id);
		$this->db->where('master_menu.status', 1);
		$this->db->order_by('master_menu.menu_sort', "ASC");
		$this->db->group_by('user_role_permission.menu_id');
		$query_result = $this->db->get('master_menu,user_role_permission');
		$result = $query_result->result();
		return $result;
	}

	public function select_menu_by_module_id($id, $user_id)
	{
		$this->db->select('master_menu.*');
		$this->db->where('user_role_permission.user_id', $user_id);
		$this->db->join('master_menu', 'master_menu.id = user_role_permission.menu_id');
		$this->db->where('master_menu.module_id', $id);
		$this->db->where('master_menu.status', 1);
		$this->db->order_by('master_menu.menu_sort', "ASC");
		$this->db->group_by('user_role_permission.menu_id');
		$query_result = $this->db->get('user_role_permission');
		$result = $query_result->result();
		return $result;
	}

	public function select_sub_menu_by_menu_id($id, $user_id)
	{
		$this->db->select('master_sub_menu.*');
		$this->db->where('user_role_permission.user_id', $user_id);
		$this->db->where('user_role_permission.sub_menu_id = master_sub_menu.id');
		$this->db->where('master_sub_menu.menu_id', $id);
		$this->db->where('master_sub_menu.status', 1);
		$this->db->order_by('master_sub_menu.sub_menu_sort', "ASC");
		$query_result = $this->db->get('master_sub_menu,user_role_permission');
		$result = $query_result->result();
		return $result;
	}

	public function select_user_profile_pic($emp_id)
	{
		$this->db->select('profile_picture');
		$this->db->where('emp_id', $emp_id);
		$query_result = $this->db->get('hr_basic');
		$result = $query_result->row();
		return $result;
	}

	public function select_student_profile_pic($student_id)
	{
		$this->db->select('picture');
		$this->db->where('student_id', $student_id);
		$query_result = $this->db->get('academic_studentinfo');
		$result = $query_result->row();
		return $result;
	}

	public function select_event($set_type)
	{
		$this->db->select('*');
		$this->db->where('sent_type', $set_type);
		$query_result = $this->db->get('master_event');
		$result = $query_result->result();
		return $result;
	}

	public function select_event_info_by_id($id)
	{
		$this->db->select('*');
		$this->db->where('id', $id);
		$query_result = $this->db->get('master_event');
		$result = $query_result->result();
		return $result;
	}

	public function check_old_password($user_name, $old_password)
	{
		$this->db->select('*');
		$this->db->where('user_name', $user_name);
		$this->db->where('password', $old_password);
		$query_result = $this->db->get('master_user');
		$result = $query_result->row();
		return $result;
	}

//	dashboard data

	public function follow_up_order($first_date, $last_date)
	{
		$this->db->select('count(id) total');
		$this->db->where('status', 1);
		$this->db->where('schedule_date IS NOT NULL', null, false);
		$this->db->where('sales_date >=', $first_date);
		$this->db->where('sales_date <=', $last_date);
		$query_result = $this->db->get('ecommerce_orders');
		$result = $query_result->row();
		return $result;
	}

	public function all_order($date, $status = null)
	{
		$this->db->select('count(id) total');
		if ($status) {
			$this->db->where('status', $status);
		}
		$this->db->where('sales_date', $date);
		$query_result = $this->db->get('ecommerce_orders');
		$result = $query_result->row();
		return $result;
	}

	public function all_sales($date, $status = null)
	{
		$this->db->select('sum(total_amount) total');
		if ($status) {
			$this->db->where('status', $status);
		}
		$this->db->where('sales_date', $date);
		$query_result = $this->db->get('ecommerce_orders');
		$result = $query_result->row();
		return $result;
	}

	public function all_order_between_date($first_date, $last_date, $status = null)
	{
		$this->db->select('count(id) total');
		$this->db->where('ecommerce_orders.sales_date >=', $first_date);
		$this->db->where('ecommerce_orders.sales_date <=', $last_date);
		if ($status) {
			$this->db->where('status', $status);
		}
		$query_result = $this->db->get('ecommerce_orders');
		$result = $query_result->row();
		return $result;
	}

	public function all_order_between_date_amount($first_date, $last_date, $status = null)
	{
		$this->db->select('sum(total_amount) total');
		$this->db->where('ecommerce_orders.sales_date >=', $first_date);
		$this->db->where('ecommerce_orders.sales_date <=', $last_date);
		if ($status) {
			$this->db->where('status', $status);
		}
		$query_result = $this->db->get('ecommerce_orders');
		$result = $query_result->row();
		return $result;
	}

	public function order_sources($first_date, $last_date, $source)
	{
		$this->db->select('sum(total_amount) total_amount, count(id) total_qty');
		$this->db->where('sales_date >=', $first_date);
		$this->db->where('sales_date <=', $last_date);
		$this->db->where('traffic_source', $source);
		$query_result = $this->db->get('ecommerce_orders');
		$result = $query_result->row();
		return $result;
	}

	public function top_selling_product($first_date, $last_date)
	{
		$this->db->select('inventory_product.product_name,inventory_product.product_image,ecommerce_order_details.product_id, COUNT(ecommerce_order_details.qty) as total');
		$this->db->join('inventory_product', 'inventory_product.id = ecommerce_order_details.product_id');
		$this->db->join('ecommerce_orders', 'ecommerce_orders.user_id = ecommerce_order_details.user_id');
		$this->db->where('ecommerce_orders.sales_date >=', $first_date);
		$this->db->where('ecommerce_orders.sales_date <=', $last_date);
		$this->db->group_by('ecommerce_order_details.product_id,inventory_product.product_name,inventory_product.product_image');
		$this->db->order_by('total', 'desc');
		$query_result = $this->db->get('ecommerce_order_details', 9);
		$result = $query_result->result();
		return $result;
	}

	public function customer_of_the_month($first_date, $last_date)
	{
		$this->db->select('ecommerce_orders.user_name,ecommerce_order_details.user_id, COUNT(ecommerce_order_details.qty) as total');
		$this->db->join('ecommerce_orders', 'ecommerce_orders.user_id = ecommerce_order_details.user_id');
		$this->db->where('ecommerce_orders.sales_date >=', $first_date);
		$this->db->where('ecommerce_orders.sales_date <=', $last_date);
		$this->db->group_by('ecommerce_order_details.user_id,ecommerce_orders.user_name');
		$this->db->order_by('total', 'desc');
		$query_result = $this->db->get('ecommerce_order_details', 9);
		$result = $query_result->result();
		return $result;
	}


//    ===========================
//    dynamic function start here
//    =========================

	public function select_journal_for_ledger($from_date, $to_date, $head_id)
	{
		$this->db->select('account_journal_child.head_id,account_chart_of_accounts.account_name');
		$this->db->where('account_journal.voucher_date >=', $from_date);
		$this->db->where('account_journal.voucher_date <=', $to_date);
		$this->db->join('account_journal_child', 'account_journal_child.parent_journal_id=account_journal.id');
		$this->db->join('account_chart_of_accounts', 'account_chart_of_accounts.id=account_journal_child.head_id');
		$this->db->where('account_journal_child.head_id', $head_id);
		$this->db->group_by('account_journal_child.head_id');
		$query_result = $this->db->get('account_journal');
		$result = $query_result->result();
		return $result;
	}

	public function select_pair_head_name($head_id, $from_date, $to_date)
	{
		$this->db->select('account_journal.voucher_no,account_journal_child.pair_transaction_id,account_journal_child.amount,account_journal_child.type,account_journal.voucher_date,account_chart_of_accounts.account_name');
		$this->db->where('account_journal_child.head_id', $head_id);
		$this->db->join('account_journal', 'account_journal.id = account_journal_child.parent_journal_id');
		$this->db->join('account_chart_of_accounts', 'account_chart_of_accounts.id = account_journal_child.pair_transaction_id');
		$this->db->where('account_journal.voucher_date >=', $from_date);
		$this->db->where('account_journal.voucher_date <=', $to_date);
		$query_result = $this->db->get('account_journal_child');
		$result = $query_result->result();
		return $result;
	}

	public function select_opening_balance($id, $date)
	{
		$this->db->select('opening_balance,balance_type');
		$this->db->where('id', $id);
		$this->db->where('effective_date', $date);
		$this->db->where('have_opening_balance', 1);
		$query_result = $this->db->get('account_chart_of_accounts');
		$result = $query_result->row();
		return $result;
	}

	public function check_have_any_opening_balance($account_head)
	{
		$this->db->select('have_opening_balance');
		$this->db->where('id', $account_head);
		$query_result = $this->db->get('account_chart_of_accounts');
		$result = $query_result->row();
		return $result;
	}

	public function check_financial_year_start_date()
	{
		$this->db->select('start_date,end_date');
		$this->db->where('status', 1);
		$query_result = $this->db->get('account_financial_year');
		$result = $query_result->row();
		return $result;
	}


	public function getValue($cond = FALSE, $tableName = '', $select_qry = '*', $order = 'ID DESC')
	{
		$prefix = $this->config->item('DX_table_prefix');
		$tableName = $prefix . $tableName;
		$this->db->select($select_qry, FALSE);
		if ($cond): $this->db->where($cond);
		endif;
		$this->db->order_by($order);
		return $this->db->get($tableName)->result();

	}

	public function getValueRow($cond = FALSE, $tableName = '', $select_qry = '*', $order = 'ID DESC')
	{
		$prefix = $this->config->item('DX_table_prefix');
		$tableName = $prefix . $tableName;
		$this->db->select($select_qry, FALSE);
		if ($cond): $this->db->where($cond);
		endif;
		$this->db->order_by($order);
		return $this->db->get($tableName)->row();

	}

	function insertData($data = '', $tableName = '')
	{
		$prefix = $this->config->item('DX_table_prefix');
		$tableName = $prefix . $tableName;
		return $this->db->insert($tableName, $data);
	}

	function insertDataWithLastId($data = '', $tableName = '')
	{
		$prefix = $this->config->item('DX_table_prefix');
		$tableName = $prefix . $tableName;
		$this->db->insert($tableName, $data);
		$insert_id = $this->db->insert_id();
		return $insert_id;
	}

	function deleteData($cond = FALSE, $tableName = '')
	{
		if (!empty($cond)): $this->db->where($cond);
		endif;
		return $this->db->delete($tableName);
	}

	function updateData($data = '', $tableName1 = '', $cond = '')
	{
		$prefix = $this->config->item('DX_table_prefix');
		$tableName = $prefix . $tableName1;
		$this->db->where($cond);
		return $this->db->update($tableName, $data);
	}

	function countAll($tableName)
	{
		return $this->db->count_all($tableName);
	}

	function countByLikeCondition($field_name, $cond, $tableName)
	{
		$this->db->like($field_name, $cond, 'after');
		return $this->db->count_all_results($tableName);
	}

	function countByWhereCondition($cond, $tableName)
	{
		$this->db->where($cond);
		return $this->db->count_all_results($tableName);
	}

	public function select_url($new_url)
	{
		$this->db->select('id,module_id,menu_id,sub_menu_url');
		$this->db->like('sub_menu_url', $new_url);
		$this->db->where('status', 1);
		$query_result = $this->db->get('master_sub_menu');
		$result = $query_result->row();
		return $result;
	}

	public function chech_permission($id, $module_id, $menu_id, $role_id)
	{
		$this->db->select('*');
		$this->db->where('module_id', $module_id);
		$this->db->where('menu_id', $menu_id);
		$this->db->where('sub_menu_id', $id);
		$this->db->where('user_id', $role_id);
		$query_result = $this->db->get('user_role_permission');
		$result = $query_result->row();
		return $result;
	}

	public function select_by_likeCondition($limit, $start, $search_data, $table_name, $field_name)
	{
		$this->db->limit($limit, $start);
		$this->db->select('*');
		$this->db->like($field_name, $search_data, 'after');
		$query_result = $this->db->get($table_name);
		$result = $query_result->result();
		return $result;
	}

	public function select_all_info($limit, $start, $table_name)
	{
		$this->db->limit($limit, $start);
		$this->db->order_by('id', "DESC");
		$query_result = $this->db->get($table_name);
		$result = $query_result->result();
		return $result;
	}

	public function check_duplicate_data($select_field, $cond, $table_name)
	{
		$this->db->select($select_field);
		$this->db->where($select_field, $cond);
		$query_result = $this->db->get($table_name);
		$result = $query_result->row();
		return $result;
	}

	function countAllByCondition($query_cond, $tableName)
	{
		$query = $this->db->where($query_cond)->get($tableName);
		return $query->num_rows();
	}

	function countByWhereConditionStatus($select_cond, $query_cond, $tableName)
	{
		$this->db->where($query_cond);
		$this->db->where($select_cond);
		return $this->db->count_all_results($tableName);
	}

	function BDT_money_formate($final_amount)
	{
		$set_amount = abs($final_amount);
		$tmp = explode(".", $set_amount);  // for float or double values
		$strMoney = "";
		$amount = $tmp[0];
		$strMoney .= substr($amount, -3, 3);
		$amount = substr($amount, 0, -3);
		while (strlen($amount) > 0) {
			$strMoney = substr($amount, -2, 2) . "," . $strMoney;
			$amount = substr($amount, 0, -2);
		}
		if (isset($tmp[1]))         // if float and double add the decimal digits here.
		{
			return $strMoney . "." . $tmp[1];
		}
		echo $strMoney . ".00";
	}

	function BDT_money_formate1($final_amount)
	{
		$set_amount = abs($final_amount);
		$tmp = explode(".", $set_amount);  // for float or double values
		$strMoney = "";
		$amount = $tmp[0];
		$strMoney .= substr($amount, -3, 3);
		$amount = substr($amount, 0, -3);
		while (strlen($amount) > 0) {
			$strMoney = substr($amount, -2, 2) . "," . $strMoney;
			$amount = substr($amount, 0, -2);
		}
		if (isset($tmp[1]))         // if float and double add the decimal digits here.
		{
			return $strMoney . "." . $tmp[1];
		}
		echo $strMoney;
	}

	function money_format1($final_amount)
	{
		$set_amount = abs($final_amount);
		$tmp = explode(".", $set_amount);  // for float or double values
		$strMoney = "";
		$amount = $tmp[0];
		$strMoney .= substr($amount, -3, 3);
		$amount = substr($amount, 0, -3);
		while (strlen($amount) > 0) {
			$strMoney = substr($amount, -2, 2) . "," . $strMoney;
			$amount = substr($amount, 0, -2);
		}
		if (isset($tmp[1]))         // if float and double add the decimal digits here.
		{
			return $strMoney . "." . $tmp[1];
		}
		echo "(" . $strMoney . ")";
	}

	function BDT_money_word($total_amount)
	{
		$number = $total_amount;
		$no = round($number);
		$point = round($number - $no, 2) * 100;
		$hundred = null;
		$digits_1 = strlen($no);
		$i = 0;
		$str = array();
		$words = array('0' => '', '1' => 'one', '2' => 'two',
			'3' => 'three', '4' => 'four', '5' => 'five', '6' => 'six',
			'7' => 'seven', '8' => 'eight', '9' => 'nine',
			'10' => 'ten', '11' => 'eleven', '12' => 'twelve',
			'13' => 'thirteen', '14' => 'fourteen',
			'15' => 'fifteen', '16' => 'sixteen', '17' => 'seventeen',
			'18' => 'eighteen', '19' => 'nineteen', '20' => 'twenty',
			'30' => 'thirty', '40' => 'forty', '50' => 'fifty',
			'60' => 'sixty', '70' => 'seventy',
			'80' => 'eighty', '90' => 'ninety');
		$digits = array('', 'hundred', 'thousand', 'lakh', 'crore');
		while ($i < $digits_1) {
			$divider = ($i == 2) ? 10 : 100;
			$number = floor($no % $divider);
			$no = floor($no / $divider);
			$i += ($divider == 10) ? 1 : 2;
			if ($number) {
				$plural = (($counter = count($str)) && $number > 9) ? 's' : null;
				$hundred = ($counter == 1 && $str[0]) ? ' and ' : null;
				$str [] = ($number < 21) ? $words[$number] .
					" " . $digits[$counter] . $plural . " " . $hundred
					:
					$words[floor($number / 10) * 10]
					. " " . $words[$number % 10] . " "
					. $digits[$counter] . $plural . " " . $hundred;
			} else $str[] = null;
		}
		$str = array_reverse($str);
		$result = implode('', $str);
		$points = ($point) ?
			"." . $words[$point / 10] . " " .
			$words[$point = $point % 10] : '';
		$get_result = ucwords($result);
		echo $get_result . "Taka";
	}


}
