<?php

class Exam_no extends MX_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('master/Exam_no_model');
	}

	public function index()
	{

	}

	public function all_exam_no()
	{
		$this->config->load('pagination');
		$this->load->library("pagination");
		$config = array();
		$config["base_url"] = base_url() . "master/exam_no/all_exam_no";
		$config["total_rows"] = $this->Main_model->countAll('biddapit_exam_no');
		$config['per_page'] = 20;
		$config['uri_segment'] = 4;
		$config['num_links'] = 9;
		$this->pagination->initialize($config);
		$page = ($this->uri->segment(4)) ? $this->uri->segment(4) : 0;
		$data["menu"] = $this->Exam_no_model->select_all_exam_no($config["per_page"], $page);
		$data["links"] = $this->pagination->create_links();
		if ($this->input->is_ajax_request()) {
			$this->load->view('exam_no/per_page_exam_no', $data);
		} else {
			$this->load->view('exam_no/exam_no_tpl', $data);
		}
	}

	public function load_add_exam_no_from()
	{
		$this->load->view('master/exam_no/exam_no_from');
	}

	public function create_exam_no()
	{
		$data = array(
			'exam_no' => $this->input->post('exam_no')
		);
		$result = $this->Main_model->insertData($data, 'biddapit_exam_no');
		if ($result) {
			$msg['load_success_message'] = "Exam successfully added.";
			$this->load->view('messages/success_message', $msg);
		}
	}


	public function load_update_exam_no_from()
	{
		$id = $this->input->post('id');
		$data['exam'] = $this->Main_model->getValue("id = '$id'", 'biddapit_exam_no', '*', "ID DESC");
		$this->load->view('master/exam_no/update_exam_no_from', $data);
	}

	public function update_exam_no()
	{
		$id = $this->input->post('id');
		$data = array(
			'exam_no' => $this->input->post('exam_no')
		);
		$result = $this->Main_model->updateData($data, "biddapit_exam_no", "id='$id'");
		if ($result) {
			$msg['load_success_message'] = "Exam update successfully.";
			$this->load->view('messages/success_message', $msg);
		}
	}
}

?>
