<?php

class Subject extends MX_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('master/Subject_model');

	}

	public function all_subject()
	{
		$institute_id = $this->session->userdata('institute_id');
		$this->config->load('pagination');
		$this->load->library("pagination");
		$config = array();
		$config["base_url"] = base_url() . "master/subject/all_subject";
		$result = $this->Subject_model->countAll($institute_id);
		$config["total_rows"] = $result->count_total_rows;
		$config['per_page'] = 20;
		$config['uri_segment'] = 4;
		$config['num_links'] = 2;
		$this->pagination->initialize($config);
		$page = ($this->uri->segment(4)) ? $this->uri->segment(4) : 0;
		$data["subject"] = $this->Subject_model->select_all_subject($config["per_page"], $page, $institute_id);
		$data["links"] = $this->pagination->create_links();
		if ($this->input->is_ajax_request()) {
			$this->load->view('master/subject/per_page_subject', $data);
		} else {
			$this->load->view('master/subject/subject_tpl', $data);
		}
	}

	public function load_add_subject_from()
	{
		$this->load->view('master/subject/subject_from');
	}

	public function create_subject()
	{
		$institute_id = $this->session->userdata('institute_id');
		$data = array(
			'institute_id' => $institute_id,
			'name' => $this->input->post('name'),
			'subject_code' => $this->input->post('code')
		);
		$result = $this->Main_model->insertData($data, 'master_subject');
		if ($result) {
			$msg['load_success_message'] = "Subject successfully added.";
			$this->load->view('messages/success_message', $msg);
		}
	}

	public function delete_subject($id)
	{
		$this->Main_model->deleteData("id = '$id'", "master_subject");
	}

	public function load_update_subject_from($id)
	{
		$data['subject'] = $this->Main_model->getValue("id = '$id'", 'master_subject', '*', "ID DESC");
		$this->load->view('master/subject/update_subject_from', $data);
	}

	public function update_subject()
	{
		$institute_id = $this->session->userdata('institute_id');
		$id = $this->input->post('id');
		$data = array(
			'institute_id' => $institute_id,
			'name' => $this->input->post('name'),
			'subject_code' => $this->input->post('code')
		);
		$result = $this->Main_model->updateData($data, "master_subject", "id='$id'");
		if ($result) {
			$msg['load_success_message'] = "Subject update successfully.";
			$this->load->view('messages/success_message', $msg);
		}
	}
}

?>
