<?php

class Year extends MX_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('master/Year_model');
	}

	public function index()
	{

	}

	public function all_year()
	{
		$this->config->load('pagination');
		$this->load->library("pagination");
		$config = array();
		$config["base_url"] = base_url() . "master/year/all_year";
		$config["total_rows"] = $this->Main_model->countAll('master_year');
		$config['per_page'] = 20;
		$config['uri_segment'] = 4;
		$config['num_links'] = 9;
		$this->pagination->initialize($config);
		$page = ($this->uri->segment(4)) ? $this->uri->segment(4) : 0;
		$data["menu"] = $this->Year_model->select_all_year($config["per_page"], $page);
		$data["links"] = $this->pagination->create_links();
		if ($this->input->is_ajax_request()) {
			$this->load->view('year/per_page_year', $data);
		} else {
			$this->load->view('year/year_tpl', $data);
		}
	}

	public function load_add_year_from()
	{
		$this->load->view('master/year/year_from');
	}

	public function create_year()
	{
		$data = array(
			'year_name' => $this->input->post('year_name')
		);
		$result = $this->Main_model->insertData($data, 'master_year');
		if ($result) {
			$msg['load_success_message'] = "Year successfully added.";
			$this->load->view('messages/success_message', $msg);
		}
	}


	public function load_update_year_from()
	{
		$id = $this->input->post('id');
		$data['year'] = $this->Main_model->getValue("id = '$id'", 'master_year', '*', "ID DESC");
		$this->load->view('master/year/update_year_from', $data);
	}

	public function update_year()
	{
		$id = $this->input->post('id');
		$data = array(
			'year_name' => $this->input->post('year_name')
		);
		$result = $this->Main_model->updateData($data, "master_year", "id='$id'");
		if ($result) {
			$msg['load_success_message'] = "Year update successfully.";
			$this->load->view('messages/success_message', $msg);
		}
	}
}

?>
