<main class="main">
    <div class="mb-lg-2"></div>
    <div class="container-fluid">
        <div class="row">
            <div class="col-xl-9 col-xxl-8 offset-lg-3 offset-xxl-2">
                <main class="main">
                    <div class="page-header text-center"
                         style="background-image: url('<?php echo base_url() ?>web_assets/images/page-header-bg.jpg')">
                        <div class="container">
                            <h1 class="page-title">Shopping Cart<span>Shop</span></h1>
                        </div><!-- End .container -->
                    </div><!-- End .page-header -->
                    <nav aria-label="breadcrumb" class="breadcrumb-nav">
                        <div class="container">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="index.html">Home</a></li>
                                <li class="breadcrumb-item"><a href="#">Shop</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Shopping Cart</li>
                            </ol>
                        </div><!-- End .container -->
                    </nav><!-- End .breadcrumb-nav -->

                    <div class="page-content">
                        <div class="cart">
                            <div class="container">
                                <div class="row">
                                    <div class="col-lg-9">
                                        <table class="table table-cart table-mobile">
                                            <thead>
                                            <tr>
                                                <th>Product</th>
                                                <th>Price</th>
                                                <th>Quantity</th>
                                                <th>Total</th>
                                                <th></th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php
                                            $sub_total = 0;
                                            foreach ($cart_product as $v_cart_product) {
                                                $sub_total += $v_cart_product->price;
                                                ?>
                                                <tr id="remove_cart<?php echo $v_cart_product->product_id; ?>">
                                                    <td class="product-col">
                                                        <div class="product">
                                                            <figure class="product-media">
                                                                <a href="#">
                                                                    <img
                                                                        src="<?php echo base_url() ?>public/product/<?php echo $v_cart_product->product_image; ?>"
                                                                        alt="Product image">
                                                                </a>
                                                            </figure>
                                                            <h3 class="product-title">
                                                                <a href="#"><?php echo $v_cart_product->product_name; ?></a>
                                                            </h3><!-- End .product-title -->
                                                        </div><!-- End .product -->
                                                    </td>
                                                    <td class="price-col">
                                                        <input value="<?php echo $v_cart_product->unit_price; ?>"
                                                               id="price<?php echo $v_cart_product->product_id; ?>"
                                                               type="hidden">
                                                        <?php echo $v_cart_product->unit_price; ?>
                                                    </td>
                                                    <td class="quantity-col">
                                                        <div class="cart-product-quantity">
                                                            <div class="btn-group" role="group"
                                                                 aria-label="Basic example">
                                                                <button
                                                                    onclick="decrement_to_cart1(<?php echo $v_cart_product->product_id; ?>)"
                                                                    type="button" style="width: 40px;">-
                                                                </button>
                                                                <input
                                                                    id="initial_value<?php echo $v_cart_product->product_id; ?>"
                                                                    value="<?php echo $v_cart_product->qty; ?>"
                                                                    readonly="readonly"
                                                                    type="text"
                                                                    style="width: 40px; text-align: center;">
                                                                <button
                                                                    onclick="increment_to_cart1(<?php echo $v_cart_product->product_id; ?>)"
                                                                    type="button" style="width: 40px;">+
                                                                </button>
                                                            </div>
                                                        </div><!-- End .cart-product-quantity -->
                                                    </td>
                                                    <td class="total-col"
                                                        id="single_total<?php echo $v_cart_product->product_id; ?>">
                                                        <?php echo $v_cart_product->price; ?>.00 tk
                                                        <input type="hidden"
                                                               id="single_total_header<?php echo $v_cart_product->product_id; ?>"
                                                               value="<?php echo $v_cart_product->price; ?>">
                                                    </td>
                                                    <td class="remove-col">
                                                        <button
                                                            onclick="remove_cart_product(<?php echo $v_cart_product->product_id; ?>)"
                                                            class="btn-remove"><i class="icon-close"></i></button>
                                                    </td>
                                                </tr>
                                            <?php } ?>
                                            </tbody>

                                        </table><!-- End .table table-wishlist -->

                                        <div class="cart-bottom">
                                            <div class="cart-discount">
                                                <form action="#">
                                                    <div class="input-group">
                                                        <input type="text" class="form-control" required
                                                               placeholder="coupon code">
                                                        <div class="input-group-append">
                                                            <button class="btn btn-outline-primary-2" type="submit"><i
                                                                    class="icon-long-arrow-right"></i></button>
                                                        </div><!-- .End .input-group-append -->
                                                    </div><!-- End .input-group -->
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                    <aside class="col-lg-3">
                                        <div class="summary summary-cart">
                                            <h3 class="summary-title">Cart Total</h3><!-- End .summary-title -->

                                            <table class="table table-summary">
                                                <tbody>
                                                <tr class="summary-subtotal">
                                                    <td>Subtotal:</td>
                                                    <td id="sub_total_all">
                                                        <input type="hidden" id="total_price_header"
                                                               value="<?php echo $sub_total; ?>">
                                                        <span class="cart-total-price" id="set_total_header">
                                                            <?php echo $sub_total; ?>.00 tk
                                                        </span>
                                                    </td>
                                                </tr><!-- End .summary-subtotal -->
                                                <tr class="summary-shipping">
                                                    <td>Shipping:</td>
                                                    <td>&nbsp;</td>
                                                </tr>

                                                <tr class="summary-shipping-row">
                                                    <td>
                                                        <div class="custom-control custom-radio">
                                                            <input type="radio" id="free-shipping" name="shipping"
                                                                   class="custom-control-input">
                                                            <label class="custom-control-label" for="free-shipping">Delivery
                                                                Charge</label>
                                                        </div><!-- End .custom-control -->
                                                    </td>
                                                    <td id="delivery_charge">
                                                        <?php echo $delivery_charge; ?>.00 tk
                                                    </td>
                                                </tr><!-- End .summary-shipping-row -->

                                                <tr class="summary-total">
                                                    <td>Total:</td>
                                                    <td id="final_total"><?php echo $sub_total + $delivery_charge; ?>.00
                                                        tk
                                                    </td>
                                                </tr><!-- End .summary-total -->
                                                </tbody>
                                            </table><!-- End .table table-summary -->

                                            <a href="<?php echo base_url() ?>welcome/checkout/<?php echo $unique_number; ?>"
                                               class="btn btn-outline-primary-2 btn-order btn-block">PROCEED TO
                                                CHECKOUT</a>
                                        </div><!-- End .summary -->

                                        <a href="<?php echo base_url() ?>"
                                           class="btn btn-outline-dark-2 btn-block mb-3"><span>CONTINUE SHOPPING</span><i
                                                class="icon-refresh"></i></a>
                                    </aside><!-- End .col-lg-3 -->
                                </div><!-- End .row -->
                            </div><!-- End .container -->
                        </div><!-- End .cart -->
                    </div><!-- End .page-content -->
                </main><!-- End .main -->
            </div>
        </div>
    </div>
</main>

<script>
    function increment_to_cart1($product_id) {
        var product_id = $product_id;
        var price = $('#price' + product_id + "").val();
        var unique_number = "<?php echo $unique_number;?>";
        var current_qty = $('#initial_value' + product_id + "").val();
        var increment_qty = parseInt(current_qty) + 1;
        $('#initial_value' + product_id + "").val(increment_qty);
        var single_amount = increment_qty * price;
        $('#single_total' + product_id + "").html(single_amount + ".00 tk");

        $.ajax({
            type: "POST",
            url: '<?php echo base_url() ?>welcome/increment_to_cart',
            data: {
                product_id: product_id,
                price: price,
                unique_number: unique_number,
                increment_qty: increment_qty
            },
            success: function (result) {
                if (result) {
                    var new_result = result.split(',');
                    var item = new_result[0];
                    var amount = new_result[1];
                    var delivery = new_result[2];
                    var final_total = parseInt(amount) + parseInt(delivery);
                    $('#total_cart_item_in_box').html(item);
                    $('#total_price_in_box').html(amount + ".00 tk");
                    $('#sub_total_all').html(amount + ".00 tk");
                    $('#delivery_charge').html(delivery + ".00 tk");
                    $('#final_total').html(final_total + ".00 tk");
                    return false;
                } else {
                    return false;
                }
            }
        });
        return false;
    }
</script>

<script>
    function decrement_to_cart1($product_id) {
        var product_id = $product_id;
        var price = $('#price' + product_id + "").val();
        var unique_number = "<?php echo $unique_number;?>";
        var current_qty = $('#initial_value' + product_id + "").val();
        var decrement_qty = parseInt(current_qty) - 1;
        if (decrement_qty <= 0) {
            $('#initial_value' + product_id + "").val(1);
            var single_amount = 1 * price;
            $('#single_total' + product_id + "").html(single_amount + ".00 tk");
        } else {
            var single_amount = decrement_qty * price;
            $('#single_total' + product_id + "").html(single_amount + ".00 tk");
            $('#initial_value' + product_id + "").val(decrement_qty);
            $.ajax({
                type: "POST",
                url: '<?php echo base_url() ?>welcome/decrement_to_cart',
                data: {
                    product_id: product_id,
                    price: price,
                    unique_number: unique_number,
                    decrement_qty: decrement_qty
                },
                success: function (result) {
                    if (result) {
                        var new_result = result.split(',');
                        var item = new_result[0];
                        var amount = new_result[1];
                        var delivery = new_result[2];
                        var final_total = parseInt(amount) + parseInt(delivery);
                        $('#total_cart_item_in_box').html(item);
                        $('#total_price_in_box').html(amount + ".00 tk");
                        $('#sub_total_all').html(amount + ".00 tk");
                        $('#delivery_charge').html(delivery + ".00 tk");
                        $('#final_total').html(final_total + ".00 tk");
                        return false;
                    } else {
                        return false;
                    }
                }
            });
            return false;
        }
    }
</script>